/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import java.util.Optional;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class JWTAuthenticationContextProvider
implements ISubjectInformationProvider<Jwt> {
    @Override
    public Jwt get() {
        return this.getAuthentication().map(AbstractOAuth2TokenAuthenticationToken::getToken).orElse(null);
    }

    private Optional<JwtAuthenticationToken> getAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        return Optional.ofNullable(context.getAuthentication()).filter(JwtAuthenticationToken.class::isInstance).map(JwtAuthenticationToken.class::cast);
    }
}

