/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import java.util.Optional;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;

public class KeycloakService {
    private final String serverUrl;
    private final String realm;
    private String clientId;
    private String clientSecret;
    private String userName;
    private String password;

    public KeycloakService(String serverUrl, String realm) {
        this.serverUrl = serverUrl;
        this.realm = realm;
    }

    public String getRealmUrl() {
        return this.serverUrl + "/realms/" + this.realm;
    }

    public String getCertsEndpoint() {
        return this.getRealmUrl() + "/protocol/openid-connect/certs";
    }

    public void setCredentials(String clientId, String clientSecret, String userName, String password) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userName = userName;
        this.password = password;
    }

    public IConnectorFactory createConnectorFactory() {
        return addr -> new JSONConnector(new HTTPConnector(addr, this::getTokenAsBearer));
    }

    public JwtBearerTokenAuthenticationConfiguration createJwtBearerTokenAuthenticationConfiguration() {
        return JwtBearerTokenAuthenticationConfiguration.of(this.getRealmUrl(), this.getCertsEndpoint(), null);
    }

    public Keycloak getKeycloak() {
        return KeycloakBuilder.builder().serverUrl(this.serverUrl).realm(this.realm).grantType("password").clientId(this.clientId).clientSecret(this.clientSecret).username(this.userName).password(this.password).build();
    }

    public Optional<String> getTokenAsBearer() {
        return this.getToken().map(token -> "Bearer " + token);
    }

    public Optional<String> getToken() {
        Keycloak keycloak = this.getKeycloak();
        return Optional.ofNullable(keycloak.tokenManager().getAccessToken().getToken());
    }
}

