/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.submodel.restapi.operation.AsyncOperationHandler;
import org.eclipse.basyx.submodel.restapi.operation.CallbackResponse;
import org.eclipse.basyx.submodel.restapi.operation.DelegatedInvocationManager;
import org.eclipse.basyx.submodel.restapi.operation.ExecutionState;
import org.eclipse.basyx.submodel.restapi.operation.InvocationRequest;
import org.eclipse.basyx.submodel.restapi.operation.InvocationResponse;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;

public class OperationProvider
implements IModelProvider {
    public static final String ASYNC = "?async=true";
    public static final String INVOCATION_LIST = "invocationList";
    public String operationId;
    private IModelProvider modelProvider;
    private DelegatedInvocationManager invocationHelper;

    public OperationProvider(IModelProvider modelProvider) {
        this(modelProvider, new DelegatedInvocationManager(new HTTPConnectorFactory()));
    }

    public OperationProvider(IModelProvider modelProvider, DelegatedInvocationManager invocationHelper) {
        this.modelProvider = modelProvider;
        this.invocationHelper = invocationHelper;
        this.operationId = this.getIdShort(modelProvider.getValue(""));
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        String[] splitted = VABPathTools.splitPath(path);
        if (path.isEmpty()) {
            return this.modelProvider.getValue("");
        }
        if (this.isInvocationListQuery(splitted)) {
            String requestId = splitted[1];
            return AsyncOperationHandler.retrieveResult(requestId, this.operationId);
        }
        throw new MalformedRequestException("Get of an Operation supports only empty or /invocationList/{requestId} paths");
    }

    private boolean isInvocationListQuery(String[] splitted) {
        return splitted[0].equals(INVOCATION_LIST) && splitted.length == 2;
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        throw new MalformedRequestException("Set not allowed at path '" + path + "'");
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        throw new MalformedRequestException("Create not allowed at path '" + path + "'");
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        throw new MalformedRequestException("Delete not allowed at path '" + path + "'");
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete not allowed at path '" + path + "'");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameters) throws ProviderException {
        boolean isAsync = this.isAsyncInvokePath(path);
        Object childElement = this.modelProvider.getValue(path = VABPathTools.stripInvokeFromPath(path));
        if (!Operation.isOperation(childElement)) {
            throw new MalformedRequestException("Only operations can be invoked.");
        }
        Operation op = Operation.createAsFacade((Map)childElement);
        if (DelegatedInvocationManager.isDelegatingOperation(op)) {
            return this.invocationHelper.invokeDelegatedOperation(op, parameters);
        }
        InvocationRequest request = this.getInvocationRequest(parameters, op);
        if (request != null && isAsync) {
            return this.handleAsyncRequestInvokation(op, request);
        }
        if (request != null) {
            return this.handleSyncRequestInvokation(op, request);
        }
        if (isAsync) {
            return this.handleAsyncParameterInvokation(op, parameters);
        }
        return this.handleSyncParameterInvokation(op, parameters);
    }

    private CallbackResponse handleAsyncRequestInvokation(Operation operation, InvocationRequest request) {
        Collection<IOperationVariable> outputVars = this.copyOutputVariables(operation);
        AsyncOperationHandler.invokeAsync(operation, this.operationId, request, outputVars);
        return new CallbackResponse(request.getRequestId(), "");
    }

    private InvocationResponse handleSyncRequestInvokation(Operation operation, InvocationRequest request) {
        SubmodelElement[] inputVariables = this.getSumbodelElementsFromInvocationRequest(request);
        SubmodelElement[] submodelElementsResult = operation.invoke(inputVariables);
        return this.createInvocationResponseFromSubmodelElementsResult(request, submodelElementsResult);
    }

    private SubmodelElement[] getSumbodelElementsFromInvocationRequest(InvocationRequest request) {
        Collection<IOperationVariable> inputVariables = request.getInputArguments();
        Stream<IOperationVariable> inputVariablesStream = StreamSupport.stream(inputVariables.spliterator(), false);
        Stream<SubmodelElement> submodelElementStream = inputVariablesStream.map(inputVar -> (SubmodelElement)inputVar.getValue());
        return (SubmodelElement[])submodelElementStream.toArray(SubmodelElement[]::new);
    }

    private CallbackResponse handleAsyncParameterInvokation(Operation operation, Object[] parameters) {
        Object[] unwrappedParameters = this.unwrapDirectParameters(parameters);
        Collection<IOperationVariable> outputVars = this.copyOutputVariables(operation);
        String requestId = UUID.randomUUID().toString();
        AsyncOperationHandler.invokeAsync(operation, this.operationId, requestId, unwrappedParameters, outputVars, 10000);
        return new CallbackResponse(requestId, "");
    }

    private Object handleSyncParameterInvokation(Operation operation, Object[] parameters) {
        Object[] unwrappedParameters = this.unwrapDirectParameters(parameters);
        Object directResult = operation.invokeSimple(unwrappedParameters);
        return directResult;
    }

    private boolean isAsyncInvokePath(String path) {
        return path.endsWith(ASYNC);
    }

    private InvocationResponse createInvocationResponseFromSubmodelElementsResult(InvocationRequest request, SubmodelElement[] submodelElementsResult) {
        ArrayList<IOperationVariable> outputs;
        if (submodelElementsResult == null) {
            outputs = new ArrayList();
        } else {
            Stream<SubmodelElement> submodelElementsStream = Arrays.stream(submodelElementsResult);
            Stream<OperationVariable> operationVariableStream = submodelElementsStream.map(submodelElement -> new OperationVariable((SubmodelElement)submodelElement));
            outputs = operationVariableStream.collect(Collectors.toList());
        }
        return new InvocationResponse(request.getRequestId(), new ArrayList<IOperationVariable>(), outputs, ExecutionState.COMPLETED);
    }

    private InvocationRequest getInvocationRequest(Object[] parameters, Operation op) {
        if (!this.isInvokationRequest(parameters)) {
            return null;
        }
        Map requestMap = (Map)parameters[0];
        InvocationRequest request = InvocationRequest.createAsFacade(requestMap);
        Collection<IOperationVariable> vars = op.getInputVariables();
        Collection<IOperationVariable> ordered = this.createOrderedInputVariablesList(request, vars);
        return new InvocationRequest(request.getRequestId(), request.getInOutArguments(), ordered, request.getTimeout());
    }

    private Collection<IOperationVariable> createOrderedInputVariablesList(InvocationRequest request, Collection<IOperationVariable> vars) {
        ArrayList<IOperationVariable> ordered = new ArrayList<IOperationVariable>();
        for (IOperationVariable var : vars) {
            String id = var.getValue().getIdShort();
            ordered.add(this.findOperationVariableById(id, request.getInputArguments()));
        }
        return ordered;
    }

    private IOperationVariable findOperationVariableById(String id, Collection<IOperationVariable> vars) {
        for (IOperationVariable input : vars) {
            if (!input.getValue().getIdShort().equals(id)) continue;
            return input;
        }
        throw new MalformedRequestException("Expected parameter " + id + " missing in request");
    }

    private boolean isInvokationRequest(Object[] parameters) {
        if (parameters.length != 1) {
            return false;
        }
        return InvocationRequest.isInvocationRequest(parameters[0]);
    }

    private Collection<IOperationVariable> copyOutputVariables(Operation op) {
        Collection<IOperationVariable> outputs = op.getOutputVariables();
        ArrayList<IOperationVariable> outCopy = new ArrayList<IOperationVariable>();
        outputs.stream().forEach(o -> outCopy.add(new OperationVariable(o.getValue().getLocalCopy())));
        return outCopy;
    }

    private String getIdShort(Object operation) {
        if (Operation.isOperation(operation)) {
            return Operation.createAsFacade((Map)operation).getIdShort();
        }
        throw new ProviderException("The Object this OperationProvider is pointing to is not an Operation");
    }

    private Object[] unwrapDirectParameters(Object[] parameters) {
        Object[] unwrappedParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Map map;
            Object parameter = parameters[i];
            unwrappedParameters[i] = parameter instanceof Map && (map = (Map)parameter).get("valueType") != null && map.containsKey("value") ? map.get("value") : parameter;
        }
        return unwrappedParameters;
    }
}

