/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueTypeHelper;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.vab.VABSubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProvider;

public class SubmodelProvider
implements IModelProvider {
    public static final String VALUES = "values";
    public static final String SUBMODEL = "submodel";
    public static final String FILE = "File";
    public static final String UPLOAD = "upload";
    ISubmodelAPI submodelAPI;

    public SubmodelProvider() {
        this(new Submodel());
    }

    public SubmodelProvider(IModelProvider provider) {
        this.submodelAPI = new VABSubmodelAPI(provider);
    }

    public SubmodelProvider(Submodel model) {
        this.submodelAPI = new VABSubmodelAPI(new VABLambdaProvider(model));
    }

    public SubmodelProvider(ISubmodelAPI submodelAPI) {
        this.submodelAPI = submodelAPI;
    }

    private String removeSubmodelPrefix(String path) {
        String submodelWithSlash;
        if ((path = VABPathTools.stripSlashes(path)).startsWith(submodelWithSlash = "submodel/")) {
            path = path.replaceFirst(submodelWithSlash, "");
        } else if (path.equals(SUBMODEL)) {
            path = "";
        } else {
            throw new MalformedRequestException("The request " + path + " is not allowed for this endpoint. /submodel is missing");
        }
        path = VABPathTools.stripSlashes(path);
        return path;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = this.removeSubmodelPrefix(path);
        if (path.isEmpty()) {
            return this.handleEmptyPath();
        }
        String[] splitted = VABPathTools.splitPath(path);
        if (this.isRequestForAllSubmodelElementValues(splitted)) {
            return this.getSubmodelProviderValues();
        }
        if (this.isSubmodelElementsRequest(splitted)) {
            return this.submodelAPI.getSubmodelElements();
        }
        if (this.isSpecificSubmodelElementRequest(splitted)) {
            path = this.removeSMElementPrefix(path);
            return this.handleSpecificSubmodelElementRequest(path, splitted);
        }
        throw new MalformedRequestException("Unknown path " + path + " was requested");
    }

    private Object getSubmodelProviderValues() {
        Map<String, Object> objectValues = this.submodelAPI.getSubmodel().getValues();
        this.prepareValuesForSerialization(objectValues);
        return objectValues;
    }

    private void prepareValuesForSerialization(Map<String, Object> objectValues) {
        LinkedList<Map<String, Object>> toBeTransformed = new LinkedList<Map<String, Object>>();
        toBeTransformed.add(objectValues);
        while (!toBeTransformed.isEmpty()) {
            Map currentMap = (Map)toBeTransformed.remove();
            List<Map<String, Object>> nextMaps = this.transformMapEntries(currentMap);
            toBeTransformed.addAll(nextMaps);
        }
    }

    private List<Map<String, Object>> transformMapEntries(Map<String, Object> unprocessedMap) {
        LinkedList<Map<String, Object>> unprocessedEntries = new LinkedList<Map<String, Object>>();
        for (Map.Entry<String, Object> mapEntry : unprocessedMap.entrySet()) {
            Object value = mapEntry.getValue();
            if (value instanceof Map) {
                unprocessedEntries.add((Map)value);
                continue;
            }
            Object fixedValue = ValueTypeHelper.prepareForSerialization(value);
            unprocessedMap.replace(mapEntry.getKey(), fixedValue);
        }
        return unprocessedEntries;
    }

    private List<String> getIdShorts(String[] splitted) {
        ArrayList<String> idShorts = new ArrayList<String>(Arrays.asList(splitted));
        idShorts.remove(0);
        if (splitted[splitted.length - 1].equals("value")) {
            idShorts.remove(idShorts.size() - 1);
        }
        return idShorts;
    }

    private boolean endsWithValue(String[] splitted) {
        return splitted[splitted.length - 1].equals("value");
    }

    private String removeValueSuffix(String path) {
        String suffix = "/value";
        if (path.endsWith(suffix)) {
            path = path.substring(0, path.length() - suffix.length());
        }
        return path;
    }

    private boolean isInvocationListPath(String[] splitted) {
        return splitted.length > 2 && splitted[splitted.length - 2].equals("invocationList");
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        if ((path = this.removeSubmodelPrefix(path)).isEmpty()) {
            throw new MalformedRequestException("Set on \"submodel\" not supported");
        }
        String[] splitted = VABPathTools.splitPath(path);
        path = this.removeSMElementPrefix(path);
        String idshortPath = this.removeValueSuffix(path);
        if (this.endsWithValue(splitted)) {
            this.submodelAPI.updateSubmodelElement(idshortPath, newValue);
        } else {
            ISubmodelElement element = SubmodelElementFacadeFactory.createSubmodelElement((Map)newValue);
            if (!path.endsWith(element.getIdShort())) {
                throw new MalformedRequestException("The idShort of given Element '" + element.getIdShort() + "' does not match the ending of the given path '" + path + "'");
            }
            this.submodelAPI.addSubmodelElement(idshortPath, element);
        }
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        if ((path = this.removeSubmodelPrefix(path)).isEmpty()) {
            throw new MalformedRequestException("POST on \"submodel\" not supported");
        }
        String[] splitted = VABPathTools.splitPath(path);
        if (this.endsWithFileUpload(splitted)) {
            this.submodelAPI.uploadSubmodelElementFile(this.getFileIdShortFromSplittedPath4FileUpload(splitted), (InputStream)newEntity);
            return;
        }
        throw new MalformedRequestException("POST on \"" + path + "\" not allowed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteValue(String path) throws ProviderException {
        if ((path = this.removeSubmodelPrefix(path)).isEmpty()) throw new MalformedRequestException("Path \"submodel\" not supported for delete");
        String[] splitted = VABPathTools.splitPath(path);
        if (!this.isQualifier(splitted[0])) throw new MalformedRequestException("Path " + path + " not supported for delete");
        if (splitted.length > 2) {
            path = this.removeSMElementPrefix(path);
            this.submodelAPI.deleteSubmodelElement(path);
            return;
        } else {
            this.submodelAPI.deleteSubmodelElement(this.getIdShortFromSplittedPath(splitted));
        }
    }

    private boolean isQualifier(String str) {
        return str.equals("submodelElements");
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete with a passed argument not allowed");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameters) throws ProviderException {
        String pathWithoutSubmodelPrefix = this.removeSubmodelPrefix(path);
        if (pathWithoutSubmodelPrefix.isEmpty()) {
            throw new MalformedRequestException("Given path must not be empty");
        }
        if (!VABPathTools.isOperationInvokationPath(pathWithoutSubmodelPrefix)) {
            throw new MalformedRequestException("Given path '" + path + "' does not end in /invoke");
        }
        String pathWithoutSMElementPrefix = this.removeSMElementPrefix(pathWithoutSubmodelPrefix);
        if (this.isAsyncInvokePath(pathWithoutSMElementPrefix)) {
            return this.invokeAsync(pathWithoutSMElementPrefix, parameters);
        }
        return this.invokeSync(pathWithoutSMElementPrefix, parameters);
    }

    private Object invokeSync(String path, Object ... parameters) {
        String pathWithoutInvoke = path.substring(0, path.lastIndexOf("invoke"));
        String strippedPathWithoutInvoke = VABPathTools.stripSlashes(pathWithoutInvoke);
        return this.submodelAPI.invokeOperation(strippedPathWithoutInvoke, parameters);
    }

    private Object invokeAsync(String path, Object ... parameters) {
        String pathWithoutAsyncInvoke = path.replaceFirst(Pattern.quote("invoke?async=true"), "");
        String strippedPathWithoutAsyncInvoke = VABPathTools.stripSlashes(pathWithoutAsyncInvoke);
        return this.submodelAPI.invokeAsync(strippedPathWithoutAsyncInvoke, parameters);
    }

    private boolean isAsyncInvokePath(String path) {
        return path.endsWith("?async=true");
    }

    public ISubmodelAPI getAPI() {
        return this.submodelAPI;
    }

    protected void setAPI(ISubmodelAPI api) {
        this.submodelAPI = api;
    }

    private String removeSMElementPrefix(String path) {
        return path.replaceFirst("submodelElements", "");
    }

    private boolean endsWithFile(String[] splitted) {
        return splitted[splitted.length - 1].equals(FILE);
    }

    private boolean endsWithFileUpload(String[] splitted) {
        return splitted[splitted.length - 1].equals(UPLOAD);
    }

    private String getFileIdShortFromSplittedPath4FileUpload(String[] splitted) {
        String idShort = "";
        for (int i = 1; i < splitted.length - 1; ++i) {
            idShort = this.concatFileIdShortPath(splitted, idShort, i);
        }
        return idShort;
    }

    private String getFileIdShortFromSplittedPath4FileDownload(String[] splitted) {
        String idShort = "";
        for (int i = 1; i < splitted.length - 1; ++i) {
            idShort = this.concatFileIdShortPath(splitted, idShort, i);
        }
        return idShort;
    }

    private String concatFileIdShortPath(String[] splitted, String idShort, int i) {
        idShort = idShort.isEmpty() ? idShort.concat(splitted[i]) : idShort.concat("/" + splitted[i]);
        return idShort;
    }

    private String getIdShortFromSplittedPath(String[] splitted) {
        return splitted[1];
    }

    private Object handleFile(String[] splitted) {
        String idShortPath = this.getFileIdShortFromSplittedPath4FileDownload(splitted);
        if (idShortPath.isEmpty()) {
            return this.submodelAPI.getSubmodelElement(FILE);
        }
        Map submodelElement = (Map)((Object)this.submodelAPI.getSubmodelElement(idShortPath));
        if (SubmodelElementCollection.isSubmodelElementCollection(submodelElement)) {
            SubmodelElementCollection smeCollection = SubmodelElementCollection.createAsFacade(submodelElement);
            return smeCollection.getSubmodelElement(FILE);
        }
        if (!File.isFile(submodelElement)) {
            throw new MalformedRequestException("/File is only allowed for File Submodel Elements");
        }
        return this.submodelAPI.getSubmodelElementFile(idShortPath);
    }

    private Object handleEmptyPath() {
        ISubmodel sm = this.submodelAPI.getSubmodel();
        if (sm instanceof Submodel) {
            return SubmodelElementMapCollectionConverter.smToMap((Submodel)sm);
        }
        return sm;
    }

    private Object handleSpecificSubmodelElementRequest(String path, String[] splitted) {
        if (this.endsWithValue(splitted)) {
            return this.handleValue(path);
        }
        if (this.isInvocationListPath(splitted)) {
            return this.handleInvocationListPath(splitted);
        }
        if (this.endsWithFile(splitted)) {
            return this.handleFile(splitted);
        }
        return this.submodelAPI.getSubmodelElement(path);
    }

    private Object handleValue(String path) {
        String idShortPath = this.removeValueSuffix(path);
        return this.submodelAPI.getSubmodelElementValue(idShortPath);
    }

    private Object handleInvocationListPath(String[] splitted) {
        List<String> idShorts = this.getIdShorts(splitted);
        idShorts.remove(idShorts.size() - 1);
        idShorts.remove(idShorts.size() - 1);
        return this.submodelAPI.getOperationResult(idShorts.get(0), splitted[splitted.length - 1]);
    }

    private boolean isRequestForAllSubmodelElementValues(String[] splitted) {
        return splitted.length == 1 && splitted[0].equals(VALUES);
    }

    private boolean isSubmodelElementsRequest(String[] splitted) {
        return splitted.length == 1 && splitted[0].equals("submodelElements");
    }

    private boolean isSpecificSubmodelElementRequest(String[] splitted) {
        return splitted.length >= 2 && this.isQualifier(splitted[0]);
    }
}

