/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationExecutionTimeoutException;
import org.eclipse.basyx.submodel.restapi.operation.ExecutionState;
import org.eclipse.basyx.submodel.restapi.operation.InvocationRequest;
import org.eclipse.basyx.submodel.restapi.operation.InvocationResponse;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class AsyncOperationHandler {
    private static Map<String, InvocationResponse> responses = new LinkedHashMap<String, InvocationResponse>();
    private static Map<String, String> responseOperationMap = new LinkedHashMap<String, String>();
    private static ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(0);

    public static void invokeAsync(Operation operation, String operationId, InvocationRequest request, Collection<IOperationVariable> outputArguments) {
        String requestId = request.getRequestId();
        Collection<IOperationVariable> inOutArguments = request.getInOutArguments();
        Object[] parameters = request.unwrapInputParameters();
        AsyncOperationHandler.invokeAsync(operation, operationId, requestId, parameters, inOutArguments, outputArguments, request.getTimeout());
    }

    public static void invokeAsync(Operation operation, String operationId, String requestId, Object[] inputs, Collection<IOperationVariable> outputArguments, int timeout) {
        AsyncOperationHandler.invokeAsync(operation, operationId, requestId, inputs, new ArrayList<IOperationVariable>(), outputArguments, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeAsync(Operation operation, String operationId, String requestId, Object[] inputs, Collection<IOperationVariable> inOutArguments, Collection<IOperationVariable> outputArguments, int timeout) {
        Map<String, InvocationResponse> map = responses;
        synchronized (map) {
            InvocationResponse response = new InvocationResponse(requestId, inOutArguments, outputArguments, ExecutionState.INITIATED);
            responses.put(requestId, response);
            responseOperationMap.put(requestId, operationId);
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> operation.invokeSimple(inputs)).acceptEither(AsyncOperationHandler.setTimeout(timeout, requestId), result -> {
                response.setExecutionState(ExecutionState.COMPLETED);
                if (!response.getOutputArguments().isEmpty()) {
                    IOperationVariable output = response.getOutputArguments().iterator().next();
                    output.getValue().setValue(result);
                }
            })).exceptionally(throwable -> {
                ProviderException exception = null;
                if (throwable.getCause() instanceof OperationExecutionTimeoutException) {
                    response.setExecutionState(ExecutionState.TIMEOUT);
                    exception = new ProviderException("Request " + requestId + " timed out", (Throwable)throwable);
                } else {
                    response.setExecutionState(ExecutionState.FAILED);
                    exception = new ProviderException("Request " + requestId + " failed", (Throwable)throwable);
                }
                if (!response.getOutputArguments().isEmpty()) {
                    IOperationVariable output = response.getOutputArguments().iterator().next();
                    output.getValue().setValue(exception);
                }
                return null;
            });
        }
    }

    private static CompletableFuture<Void> setTimeout(int timeout, String requestId) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        delayer.schedule(() -> result.completeExceptionally(new OperationExecutionTimeoutException("Request " + requestId + " timed out")), (long)timeout, TimeUnit.MILLISECONDS);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object retrieveResult(String requestId, String operationId) {
        Map<String, InvocationResponse> map = responses;
        synchronized (map) {
            if (!responses.containsKey(requestId)) {
                throw new ResourceNotFoundException("RequestId '" + requestId + "' not found for operation '" + operationId + "'.");
            }
            String validOperationId = responseOperationMap.get(requestId);
            if (!operationId.equals(validOperationId)) {
                throw new ResourceNotFoundException("RequestId '" + requestId + "' does not belong to Operation '" + operationId + "'");
            }
            InvocationResponse response = responses.get(requestId);
            if (ExecutionState.COMPLETED == response.getExecutionState() || ExecutionState.TIMEOUT == response.getExecutionState() || ExecutionState.FAILED == response.getExecutionState()) {
                responses.remove(requestId);
                responseOperationMap.remove(requestId);
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRequestId(String requestId) {
        Map<String, InvocationResponse> map = responses;
        synchronized (map) {
            return responses.containsKey(requestId);
        }
    }
}

