/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.webserviceclient;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.basyx.tools.webserviceclient.WebServiceRawClient;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceJSONClient {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceJSONClient.class);
    protected WebServiceRawClient client = new WebServiceRawClient();
    protected GSONTools serializer = new GSONTools((GSONToolsFactory)new DefaultTypeFactory());

    protected Object getJSONResult(String serializedJSONValue) {
        try {
            Object result = this.serializer.deserialize(serializedJSONValue);
            if (result instanceof ProviderException) {
                throw (ProviderException)result;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object get(String wsURL) {
        String jsonResult = this.client.get(wsURL);
        return this.getJSONResult(jsonResult);
    }

    public Object put(String wsURL, Object newValue) {
        String json = this.serializer.serialize(newValue);
        String jsonResult = this.client.put(wsURL, json);
        return this.getJSONResult(jsonResult);
    }

    public Object post(String wsURL, String ... parameter) {
        String json = this.serializer.serialize(this.transformArrayToList(parameter));
        String jsonResult = this.client.post(wsURL, json);
        logger.debug("Result:" + jsonResult);
        return this.getJSONResult(jsonResult);
    }

    public Object patch(String wsURL, String action, String ... parameter) {
        String json = this.serializer.serialize(this.transformArrayToList(parameter));
        String jsonResult = this.client.patch(wsURL, action, json);
        return this.getJSONResult(jsonResult);
    }

    public Object delete(String wsURL) {
        String jsonResult = this.client.delete(wsURL);
        return this.getJSONResult(jsonResult);
    }

    private <T> List<T> transformArrayToList(T[] t) {
        ArrayList<T> ret = new ArrayList<T>();
        for (int i = 0; i < t.length; ++i) {
            ret.add(t[i]);
        }
        return ret;
    }
}

