/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.aas.basyx.VersionAdjustment;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import org.eclipse.basyx.components.IComponent;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.registry.RegistryComponent;
import org.eclipse.basyx.components.registry.configuration.BaSyxRegistryConfiguration;
import org.eclipse.basyx.components.registry.configuration.RegistryBackend;

public class BaSyxServerRecipe
implements ServerRecipe {
    private String accessControlAllowOrigin;

    public ServerRecipe.PersistenceType toPersistenceType(String type) {
        ServerRecipe.LocalPersistenceType result = ServerRecipe.LocalPersistenceType.INMEMORY;
        try {
            result = ServerRecipe.LocalPersistenceType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Persistence type '" + type + "' is unknown. Using " + String.valueOf(ServerRecipe.LocalPersistenceType.INMEMORY) + " as fallback.");
        }
        return result;
    }

    public AasServer createAasServer(SetupSpec spec, ServerRecipe.PersistenceType persistence, String ... options) {
        DeploymentSpec dspec = this.applyAccessControlAllowOrigin(new DeploymentSpec(spec.getAasRepositoryEndpoint(), spec.getAasRepositoryKeyStore()));
        return VersionAdjustment.createRegistryDeploymentServer(dspec, spec, SetupSpec.AasComponent.AAS_REGISTRY, spec.getAasRegistryEndpoint().toUri(), this.translateForServer(persistence), options);
    }

    private DeploymentSpec applyAccessControlAllowOrigin(DeploymentSpec spec) {
        if (null != this.accessControlAllowOrigin) {
            spec.setAccessControlAllowOrigin(this.accessControlAllowOrigin);
        }
        return spec;
    }

    public Server createRegistryServer(SetupSpec spec, ServerRecipe.PersistenceType persistence, String ... options) {
        DeploymentSpec dspec = this.applyAccessControlAllowOrigin(new DeploymentSpec(spec.getAasRegistryEndpoint(), (KeyStoreDescriptor)null));
        RegistryBackend backend = Tools.getOption(options, this.translateForRegistry(persistence), RegistryBackend.class);
        BaSyxRegistryConfiguration registryConfig = new BaSyxRegistryConfiguration(backend);
        RegistryComponent component = new RegistryComponent(dspec.getContextConfiguration(), registryConfig);
        return new Server(){
            final /* synthetic */ IComponent val$component;
            final /* synthetic */ SetupSpec val$spec;
            {
                this.val$component = iComponent;
                this.val$spec = setupSpec;
            }

            public Server start() {
                this.val$component.startComponent();
                return this;
            }

            public void stop(boolean dispose) {
                this.val$component.stopComponent();
                if (dispose) {
                    Tools.disposeTomcatWorkingDir(null, this.val$spec.getAasRegistryEndpoint().getPort());
                }
            }
        };
    }

    protected RegistryBackend translateForRegistry(ServerRecipe.PersistenceType type) {
        if (ServerRecipe.LocalPersistenceType.INMEMORY != type) {
            throw new UnsupportedOperationException("Persistence type '" + String.valueOf(type) + "' is not supported as registry backend");
        }
        RegistryBackend result = RegistryBackend.INMEMORY;
        return result;
    }

    protected AASServerBackend translateForServer(ServerRecipe.PersistenceType type) {
        if (ServerRecipe.LocalPersistenceType.INMEMORY != type) {
            throw new UnsupportedOperationException("Persistence type '" + String.valueOf(type) + "' is not supported as server backend");
        }
        AASServerBackend result = AASServerBackend.INMEMORY;
        return result;
    }

    public ServerRecipe setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
        return this;
    }
}

