/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.internal.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPI;

public class MongoDBBaSyxStorageAPIFactory<T> {
    private static Map<String, MongoClient> knownClients = new HashMap<String, MongoClient>();
    private final BaSyxMongoDBConfiguration config;
    private final Class<T> type;
    private final String collectionName;
    private final MongoClient client;

    public MongoDBBaSyxStorageAPIFactory(BaSyxMongoDBConfiguration config, Class<T> type, String collectionName) {
        this.config = config;
        this.type = type;
        this.collectionName = collectionName;
        this.client = null;
    }

    public MongoDBBaSyxStorageAPIFactory(BaSyxMongoDBConfiguration config, Class<T> type, String collectionName, MongoClient client) {
        this.config = config;
        this.type = type;
        this.collectionName = collectionName;
        this.client = client;
    }

    public static synchronized <T> MongoDBBaSyxStorageAPI<T> create(String collectionName, Class<T> type, BaSyxMongoDBConfiguration config, MongoClient client) {
        String connectionUrl = config.getConnectionUrl();
        if (!knownClients.containsKey(connectionUrl)) {
            knownClients.put(connectionUrl, client);
        }
        return new MongoDBBaSyxStorageAPI<T>(collectionName, type, config, knownClients.get(connectionUrl));
    }

    public static synchronized <T> MongoDBBaSyxStorageAPI<T> create(String collectionName, Class<T> type, BaSyxMongoDBConfiguration config) {
        String connectionUrl = config.getConnectionUrl();
        return knownClients.containsKey(connectionUrl) ? MongoDBBaSyxStorageAPIFactory.create(collectionName, type, config, knownClients.get(connectionUrl)) : MongoDBBaSyxStorageAPIFactory.create(collectionName, type, config, MongoDBBaSyxStorageAPIFactory.createNewClient(config));
    }

    private static MongoClient createNewClient(BaSyxMongoDBConfiguration config) {
        return MongoClients.create((String)config.getConnectionUrl());
    }

    public MongoDBBaSyxStorageAPI<T> create() {
        return this.client == null ? MongoDBBaSyxStorageAPIFactory.create(this.collectionName, this.type, this.config) : MongoDBBaSyxStorageAPIFactory.create(this.collectionName, this.type, this.config, this.client);
    }
}

