/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.ExtensionBasedFileFormat;
import de.iip_ecosphere.platform.support.FileFormat;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.factory.aasx.AASXPackageExplorerConformantHelper;
import org.eclipse.basyx.aas.factory.aasx.AASXToMetamodelConverter;
import org.eclipse.basyx.aas.factory.aasx.InMemoryFile;
import org.eclipse.basyx.aas.factory.aasx.MetamodelToAASXConverter;
import org.eclipse.basyx.aas.factory.aasx.Thumbnail;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.xml.sax.SAXException;

class AasxPersistenceRecipe
extends AbstractPersistenceRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(AasxPersistenceRecipe.class);
    private static final FileFormat AASX = new ExtensionBasedFileFormat("aasx", "AASX", "AASX package");

    AasxPersistenceRecipe() {
        super(AASX);
    }

    public void writeTo(List<Aas> aas, File thumbnail, List<PersistenceRecipe.FileResource> resources, File file) throws IOException {
        if (aas.size() > 1) {
            LOGGER.warn("Writing multiple AAS to a single file may not be read back as BaSyx currently just supports one AAS to be read from an AASX package.");
        }
        ArrayList basyxAas = new ArrayList();
        ArrayList basyxSubmodels = new ArrayList();
        ArrayList<IAsset> assetList = new ArrayList<IAsset>();
        ArrayList conceptDescriptionList = new ArrayList();
        ArrayList<InMemoryFile> inMemoryFiles = new ArrayList<InMemoryFile>();
        for (Aas a : aas) {
            Object origAas = ((AbstractAas)a).getAas();
            if (null == origAas.getAsset()) {
                LOGGER.warn("AAS '{}' may not be read back correctly as it does not have an Asset.", (Object)a.getIdShort());
            } else {
                assetList.add(origAas.getAsset());
            }
            if (null == origAas.getAssetReference()) {
                LOGGER.warn("AAS '{}' may not be read back correctly as it does not have an Asset Reference.", (Object)a.getIdShort());
            }
            origAas = AasxPersistenceRecipe.ensureLocal(origAas);
            basyxAas.add(origAas);
            for (Submodel s : a.submodels()) {
                Object submodel = ((AbstractSubmodel)s).getSubmodel();
                submodel = AasxPersistenceRecipe.ensureLocal(submodel);
                basyxSubmodels.add(submodel);
            }
        }
        Thumbnail tn = null;
        FileInputStream thumbnailStream = null;
        if (null != thumbnail && thumbnail.exists()) {
            String name = thumbnail.getName();
            String extension = "";
            int pos = name.lastIndexOf(".");
            if (pos > 0 && pos < name.length() - 1) {
                extension = name.substring(pos + 1);
            }
            try {
                Thumbnail.ThumbnailExtension tnExt = Thumbnail.ThumbnailExtension.valueOf((String)extension.toUpperCase());
                thumbnailStream = new FileInputStream(thumbnail);
                tn = new Thumbnail(tnExt, (InputStream)thumbnailStream);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unknown thumbnail extension {}, ignoring thumbnail.", (Object)extension);
            }
        }
        if (null != resources) {
            for (PersistenceRecipe.FileResource f : resources) {
                inMemoryFiles.add(new InMemoryFile(f.getFileContent(), f.getPath()));
            }
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            AASXPackageExplorerConformantHelper.adapt(basyxAas, assetList, conceptDescriptionList, basyxSubmodels);
            MetamodelToAASXConverter.buildAASX(basyxAas, assetList, conceptDescriptionList, basyxSubmodels, inMemoryFiles, tn, (OutputStream)out);
            out.close();
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        FileUtils.closeQuietly((Closeable)thumbnailStream);
    }

    public List<Aas> readFrom(File file) throws IOException {
        ArrayList<Aas> result = new ArrayList<Aas>();
        try {
            AASXToMetamodelConverter apm = new AASXToMetamodelConverter(file.getAbsolutePath());
            Set bundles = apm.retrieveAASBundles();
            ArrayList<IAssetAdministrationShell> aas = new ArrayList<IAssetAdministrationShell>();
            ArrayList submodels = new ArrayList();
            ArrayList assets = new ArrayList();
            for (AASBundle b : bundles) {
                aas.add(b.getAAS());
                submodels.addAll(b.getSubmodels());
                this.transform(aas, submodels, assets, result);
                aas.clear();
                submodels.clear();
            }
        }
        catch (RuntimeException | ParserConfigurationException | InvalidFormatException | SAXException e) {
            throw new IOException(e);
        }
        return result;
    }
}

