/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.AasEnv;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.parts.ConceptDescription;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;

public class MetamodelToJSONConverter {
    public static final String ASSET_ADMINISTRATION_SHELLS = "assetAdministrationShells";
    public static final String SUBMODELS = "submodels";
    public static final String ASSETS = "assets";
    public static final String CONCEPT_DESCRIPTIONS = "conceptDescriptions";

    public static String convertToJSON(AasEnv aasEnv) {
        return MetamodelToJSONConverter.convertToJSON((List)aasEnv.getAssetAdministrationShells(), (List)aasEnv.getAssets(), (List)aasEnv.getConceptDescriptions(), (List)aasEnv.getSubmodels());
    }

    public static String convertToJSON(Collection<AssetAdministrationShell> aasList, Collection<Asset> assetList, Collection<ConceptDescription> conceptDescriptionList, Collection<Submodel> submodelList) {
        List<Object> smMapList = MetamodelToJSONConverter.submodelsToMapList(submodelList);
        LinkedHashMap<String, List<Object>> root = new LinkedHashMap<String, List<Object>>();
        root.put(ASSET_ADMINISTRATION_SHELLS, aasList == null ? new ArrayList() : aasList);
        root.put(SUBMODELS, smMapList);
        root.put(ASSETS, assetList == null ? new ArrayList() : assetList);
        root.put(CONCEPT_DESCRIPTIONS, conceptDescriptionList == null ? new ArrayList() : conceptDescriptionList);
        return new GSONTools(new DefaultTypeFactory()).serialize(root);
    }

    private static List<Object> submodelsToMapList(Collection<Submodel> submodelList) {
        if (submodelList != null) {
            return submodelList.stream().map(sm -> SubmodelElementMapCollectionConverter.smToMap(sm)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

