/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.registration.observing;

import java.util.List;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.observing.IAASRegistryServiceObserver;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.observer.Observable;
import org.eclipse.basyx.vab.exception.provider.ProviderException;

public class ObservableAASRegistryService
extends Observable<IAASRegistryServiceObserver>
implements IAASRegistry {
    private IAASRegistry aasRegistry;

    public ObservableAASRegistryService(IAASRegistry registry) {
        this.aasRegistry = registry;
    }

    @Override
    public void register(AASDescriptor deviceAASDescriptor) throws ProviderException {
        this.aasRegistry.register(deviceAASDescriptor);
        this.observers.stream().forEach(o -> o.aasRegistered(deviceAASDescriptor.getIdentifier().getId()));
    }

    @Override
    public void register(IIdentifier aas, SubmodelDescriptor smDescriptor) throws ProviderException {
        this.aasRegistry.register(aas, smDescriptor);
        this.observers.stream().forEach(o -> o.submodelRegistered(aas, smDescriptor.getIdentifier()));
    }

    @Override
    public void delete(IIdentifier aasId) throws ProviderException {
        this.aasRegistry.delete(aasId);
        this.observers.stream().forEach(o -> o.aasDeleted(aasId.getId()));
    }

    @Override
    public void delete(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        this.aasRegistry.delete(aasId, smId);
        this.observers.stream().forEach(o -> o.submodelDeleted(aasId, smId));
    }

    @Override
    public AASDescriptor lookupAAS(IIdentifier aasId) throws ProviderException {
        return this.aasRegistry.lookupAAS(aasId);
    }

    @Override
    public List<AASDescriptor> lookupAll() throws ProviderException {
        return this.aasRegistry.lookupAll();
    }

    @Override
    public List<SubmodelDescriptor> lookupSubmodels(IIdentifier aasId) throws ProviderException {
        return this.aasRegistry.lookupSubmodels(aasId);
    }

    @Override
    public SubmodelDescriptor lookupSubmodel(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        return this.aasRegistry.lookupSubmodel(aasId, smId);
    }
}

