/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.restapi;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.aas.restapi.vab.VABAASAPIFactory;
import org.eclipse.basyx.submodel.aggregator.SubmodelAggregator;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.SubmodelProvider;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;

public class MultiSubmodelProvider
implements IModelProvider {
    public static final String AAS = "aas";
    public static final String FILE = "File";
    public static final String UPLOAD = "upload";
    public static final String SUBMODELS_PREFIX = VABPathTools.concatenatePaths("aas", "submodels");
    protected AASModelProvider aas_provider = null;
    protected IIdentifier aasId = null;
    protected IAASRegistry registry = null;
    protected IConnectorFactory connectorFactory = null;
    protected IAASAPIFactory aasApiProvider;
    private ISubmodelAggregator smAggregator;

    public MultiSubmodelProvider() {
        this.setAasApiProvider(new VABAASAPIFactory());
        this.setSmAggregator(new SubmodelAggregator());
        IAASAPI aasApi = this.getAasApiProvider().create(new AssetAdministrationShell());
        this.setAssetAdministrationShell(new AASModelProvider(aasApi));
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider, IAASAPIFactory aasApiProvider, ISubmodelAPIFactory smApiProvider) {
        this.setAasApiProvider(aasApiProvider);
        this.setSmAggregator(new SubmodelAggregator(smApiProvider));
        this.setAssetAdministrationShell(contentProvider);
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider) {
        this.setAasApiProvider(new VABAASAPIFactory());
        this.setSmAggregator(new SubmodelAggregator());
        this.setAssetAdministrationShell(contentProvider);
    }

    public MultiSubmodelProvider(SubmodelProvider contentProvider) {
        this();
        this.addSubmodel(contentProvider);
    }

    public MultiSubmodelProvider(IAASRegistry registry, IConnectorFactory provider) {
        this();
        this.registry = registry;
        this.setConnectorFactory(provider);
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider, IAASRegistry registry, IConnectorFactory connectorFactory, ISubmodelAPIFactory smApiProvider, IAASAPIFactory aasApiProvider) {
        this(contentProvider, aasApiProvider, smApiProvider);
        this.registry = registry;
        this.setConnectorFactory(connectorFactory);
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider, IAASRegistry registry, IConnectorFactory connectorFactory, IAASAPIFactory aasApiProvider, ISubmodelAggregator submodelAggregator) {
        this.setAasApiProvider(aasApiProvider);
        this.setAssetAdministrationShell(contentProvider);
        this.setSmAggregator(submodelAggregator);
        this.registry = registry;
        this.setConnectorFactory(connectorFactory);
    }

    public MultiSubmodelProvider(AASModelProvider contentProvider, IAASRegistry registry, HTTPConnectorFactory provider) {
        this(contentProvider);
        this.registry = registry;
        this.setConnectorFactory(provider);
    }

    public void setAssetAdministrationShell(AASModelProvider modelContentProvider) {
        this.aas_provider = modelContentProvider;
        this.aasId = AssetAdministrationShell.createAsFacade((Map)modelContentProvider.getValue("")).getIdentification();
    }

    public void addSubmodel(SubmodelProvider modelContentProvider) {
        Submodel sm = Submodel.createAsFacade((Map)modelContentProvider.getValue("/submodel"));
        this.aas_provider.createValue("/submodels", sm);
        this.getSmAggregator().createSubmodel(modelContentProvider.getAPI());
    }

    private void createSubmodel(Object newValue) {
        Map newSubmodelMap = (Map)newValue;
        Submodel submodel = Submodel.createAsFacade(newSubmodelMap);
        this.getSmAggregator().createSubmodel(submodel);
        this.aas_provider.createValue("/submodels", submodel);
    }

    public void removeProvider(String elementIdShort) {
        this.getSmAggregator().deleteSubmodelByIdShort(elementIdShort);
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        if (pathElements.length > 0 && pathElements[0].equals(AAS)) {
            if (pathElements.length == 1) {
                return this.aas_provider.getValue("");
            }
            if (pathElements[1].equals("submodels")) {
                if (pathElements.length == 2) {
                    return this.retrieveSubmodels();
                }
                String smIdShort = pathElements[2];
                String remainingPath = VABPathTools.buildPath(pathElements, 3);
                return this.handleSingleSubmodelRequest(smIdShort, remainingPath);
            }
            String remainingPath = VABPathTools.buildPath(pathElements, 1);
            return this.aas_provider.getValue(remainingPath);
        }
        throw new MalformedRequestException("The request " + path + " is not allowed for this endpoint");
    }

    private Object handleSingleSubmodelRequest(String smIdShort, String remainingPath) {
        IModelProvider provider = this.retrieveSubmodelProvider(smIdShort);
        return provider.getValue(remainingPath);
    }

    private IModelProvider retrieveSubmodelProvider(String smIdShort) {
        IModelProvider smProvider;
        try {
            ISubmodelAPI smAPI = this.getSmAggregator().getSubmodelAPIByIdShort(smIdShort);
            smProvider = new SubmodelProvider(smAPI);
        }
        catch (ResourceNotFoundException exception) {
            smProvider = this.getRemoteSubmodelProvider(smIdShort);
        }
        return smProvider;
    }

    private Object retrieveSubmodels() throws ProviderException {
        Collection<ISubmodel> submodels = this.getSmAggregator().getSubmodelList();
        this.addConnectedSubmodels(submodels);
        return submodels.stream().map(sm -> SubmodelElementMapCollectionConverter.smToMap((Submodel)sm)).collect(Collectors.toList());
    }

    private void addConnectedSubmodels(Collection<ISubmodel> submodels) {
        if (this.registry != null) {
            AASDescriptor desc = this.registry.lookupAAS(this.aasId);
            String aasEndpoint = desc.getFirstEndpoint();
            String aasServerURL = MultiSubmodelProvider.getServerURL(aasEndpoint);
            List localIds = submodels.stream().map(sm -> sm.getIdentification().getId()).collect(Collectors.toList());
            List missingIds = desc.getSubmodelDescriptors().stream().map(d -> d.getIdentifier()).filter(id -> !localIds.contains(id.getId())).collect(Collectors.toList());
            if (!missingIds.isEmpty()) {
                List missingEndpoints = missingIds.stream().map(id -> desc.getSubmodelDescriptorFromIdentifierId(id.getId())).map(smDesc -> smDesc.getFirstEndpoint()).collect(Collectors.toList());
                for (String missingEndpoint : missingEndpoints) {
                    if (!MultiSubmodelProvider.getServerURL(missingEndpoint).equals(aasServerURL)) continue;
                    throw new ResourceNotFoundException("The Submodel at Endpoint '" + missingEndpoint + "' does not exist on this server. It seems to be registered but not actually present.");
                }
                List remoteSms = missingEndpoints.stream().map(endpoint -> this.getConnectorFactory().create((String)endpoint)).map(p -> (Map)p.getValue("")).map(m -> Submodel.createAsFacade(m)).collect(Collectors.toList());
                submodels.addAll(remoteSms);
            }
        }
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        String propertyPath = VABPathTools.buildPath(pathElements, 3);
        if (path.equals(AAS)) {
            this.createAssetAdministrationShell(newValue);
        } else {
            if (!path.startsWith(SUBMODELS_PREFIX)) {
                throw new MalformedRequestException("Access to MultiSubmodelProvider always has to start with \"" + SUBMODELS_PREFIX + "\", was " + path);
            }
            if (propertyPath.isEmpty()) {
                this.createSubmodel(newValue);
            } else {
                String smIdShort = pathElements[2];
                IModelProvider provider = this.retrieveSubmodelProvider(smIdShort);
                provider.setValue(propertyPath, newValue);
            }
        }
    }

    @Override
    public void createValue(String path, Object newValue) throws ProviderException {
        this.throwExceptionIfNoSubmodelPath(path);
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        String propertyPath = VABPathTools.buildPath(pathElements, 3);
        if (!propertyPath.isEmpty()) {
            this.throwExceptionIfIsNoFileUploadPath(propertyPath);
            String smIdShort = pathElements[2];
            IModelProvider provider = this.retrieveSubmodelProvider(smIdShort);
            provider.createValue(propertyPath, newValue);
            return;
        }
        throw new MalformedRequestException("Create is not supported by Path: " + path);
    }

    private boolean isPropertyPathFileUploadPath(String propertyPath) {
        return propertyPath.endsWith(UPLOAD);
    }

    private void throwExceptionIfIsNoFileUploadPath(String path) {
        boolean isFileUpload = this.isPropertyPathFileUploadPath(path);
        if (!isFileUpload) {
            throw new MalformedRequestException("Create is not supported by Path: " + path);
        }
    }

    private void throwExceptionIfNoSubmodelPath(String path) {
        if (!path.startsWith(SUBMODELS_PREFIX)) {
            throw new MalformedRequestException("Access to MultiSubmodelProvider always has to start with \"" + SUBMODELS_PREFIX + "\", was " + path);
        }
    }

    private void createAssetAdministrationShell(Object newAAS) {
        Map newAASMap = (Map)newAAS;
        AssetAdministrationShell shell = AssetAdministrationShell.createAsFacade(newAASMap);
        IAASAPI aasApi = this.getAasApiProvider().create(shell);
        this.aas_provider = new AASModelProvider(aasApi);
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        this.throwExceptionIfNoSubmodelPath(path);
        String[] pathElements = VABPathTools.splitPath(path);
        String propertyPath = VABPathTools.buildPath(pathElements, 3);
        if (pathElements.length == 3) {
            String smIdShort = pathElements[2];
            if (!this.isSubmodelLocal(smIdShort)) {
                return;
            }
            Submodel sm = (Submodel)this.getSmAggregator().getSubmodelbyIdShort(smIdShort);
            String smId = sm.getIdentification().getId();
            this.aas_provider.deleteValue(SUBMODELS_PREFIX + "/" + VABPathTools.encodePathElement(smId));
            this.getSmAggregator().deleteSubmodelByIdShort(smIdShort);
        } else if (propertyPath.length() > 0) {
            String smIdShort = pathElements[2];
            IModelProvider provider = this.retrieveSubmodelProvider(smIdShort);
            provider.deleteValue(propertyPath);
        }
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("DeleteValue with a parameter is not supported. Path was: " + path);
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = VABPathTools.stripSlashes(path);
        this.throwExceptionIfNoSubmodelPath(path);
        String[] pathElements = VABPathTools.splitPath(path);
        String operationPath = VABPathTools.buildPath(pathElements, 3);
        String smIdShort = pathElements[2];
        IModelProvider provider = this.retrieveSubmodelProvider(smIdShort);
        return provider.invokeOperation(operationPath, parameter);
    }

    private boolean isSubmodelLocal(String smIdShort) {
        try {
            this.getSmAggregator().getSubmodelbyIdShort(smIdShort);
            return true;
        }
        catch (ResourceNotFoundException exception) {
            return false;
        }
    }

    private boolean doesRegistryExist() {
        return this.registry != null;
    }

    private SubmodelDescriptor getSubmodelDescriptorFromRegistry(String submodelIdShort) {
        AASDescriptor aasDescriptor = this.registry.lookupAAS(this.aasId);
        SubmodelDescriptor desc = aasDescriptor.getSubmodelDescriptorFromIdShort(submodelIdShort);
        if (desc == null) {
            throw new ResourceNotFoundException("Could not resolve Submodel with idShort " + submodelIdShort + " for AAS " + this.aasId);
        }
        return desc;
    }

    private IModelProvider getRemoteSubmodelProvider(SubmodelDescriptor submodelDescriptor) {
        String endpoint = submodelDescriptor.getFirstEndpoint();
        endpoint = endpoint.substring(0, endpoint.length() - "submodel".length() - 1);
        return this.getConnectorFactory().create(endpoint);
    }

    private IModelProvider getRemoteSubmodelProvider(String submodelId) {
        if (!this.doesRegistryExist()) {
            throw new ResourceNotFoundException("Submodel with id " + submodelId + " cannot be resolved locally, but no registry is passed");
        }
        SubmodelDescriptor submodelDescriptor = this.getSubmodelDescriptorFromRegistry(submodelId);
        return this.getRemoteSubmodelProvider(submodelDescriptor);
    }

    public static String getServerURL(String endpoint) {
        int endServerURL = endpoint.indexOf("/aas");
        if (endServerURL < 0) {
            return endpoint;
        }
        return endpoint.substring(0, endServerURL);
    }

    public ISubmodelAggregator getSmAggregator() {
        return this.smAggregator;
    }

    public void setSmAggregator(ISubmodelAggregator smAggregator) {
        this.smAggregator = smAggregator;
    }

    public IAASAPIFactory getAasApiProvider() {
        return this.aasApiProvider;
    }

    public void setAasApiProvider(IAASAPIFactory aasApiProvider) {
        this.aasApiProvider = aasApiProvider;
    }

    public IConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }

    public void setConnectorFactory(IConnectorFactory connectorFactory) {
        this.connectorFactory = connectorFactory;
    }
}

