/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.api.authorization;

import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.extensions.shared.authorization.SecurityContextAuthorizer;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;

public class AuthorizedAASAPI
implements IAASAPI {
    public static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-api:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-api:write";
    private SecurityContextAuthorizer authorizer = new SecurityContextAuthorizer();
    private IAASAPI authorizedAPI;

    public AuthorizedAASAPI(IAASAPI authorizedAPI) {
        this.authorizedAPI = authorizedAPI;
    }

    @Override
    public IAssetAdministrationShell getAAS() {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.authorizedAPI.getAAS();
    }

    @Override
    public void addSubmodel(IReference submodel) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.authorizedAPI.addSubmodel(submodel);
    }

    @Override
    public void removeSubmodel(String idShort) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.authorizedAPI.removeSubmodel(idShort);
    }
}

