/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class KeycloakRoleAuthenticator
implements IRoleAuthenticator<Jwt> {
    private static final Logger logger = LoggerFactory.getLogger(KeycloakRoleAuthenticator.class);

    @Override
    public List<String> getRoles(Jwt subjectInformation) {
        return Optional.ofNullable(subjectInformation).map(info -> new JwtAuthenticationToken(subjectInformation)).map(this::jwtStr2roles).orElse(new ArrayList<String>(Collections.singletonList("anonymous")));
    }

    private List<String> jwtStr2roles(JwtAuthenticationToken token) {
        logger.info("jwtStr: {}", (Object)((Jwt)token.getToken()).getTokenValue());
        logger.info("jwt: {}", (Object)token.getTokenAttributes());
        try {
            List<String> realmRoles = this.getRealmAccessRoles(token);
            List<String> resourceRoles = this.getResoureAccessRoles(token);
            ArrayList<String> roles = new ArrayList<String>();
            roles.addAll(realmRoles);
            roles.addAll(resourceRoles);
            if (!roles.isEmpty()) {
                return roles;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<String>(Collections.singletonList("anonymous"));
    }

    private List<String> getRealmAccessRoles(JwtAuthenticationToken token) {
        Object realmAccessObject = token.getTokenAttributes().get("realm_access");
        if (realmAccessObject == null) {
            return Collections.emptyList();
        }
        return this.getCategoryRoles(realmAccessObject);
    }

    private List<String> getResoureAccessRoles(JwtAuthenticationToken token) {
        Object resourceAccessObject = token.getTokenAttributes().get("resource_access");
        if (resourceAccessObject == null) {
            return Collections.emptyList();
        }
        Map resourceAccess = (Map)resourceAccessObject;
        return resourceAccess.values().stream().map(this::getCategoryRoles).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> getCategoryRoles(Object categoryObject) {
        Map category = (Map)categoryObject;
        Object rolesObject = category.get("roles");
        if (rolesObject == null) {
            return Collections.emptyList();
        }
        return (List)rolesObject;
    }
}

