/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.qualifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IReferable;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IdShortValidator;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.vab.model.VABModelMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Referable
extends VABModelMap<Object>
implements IReferable {
    private static Logger logger = LoggerFactory.getLogger(Referable.class);
    public static final String IDSHORT = "idShort";
    public static final String CATEGORY = "category";
    public static final String DESCRIPTION = "description";
    public static final String PARENT = "parent";
    private KeyElements elem;

    public Referable() {
        this.put(IDSHORT, "");
    }

    public Referable(String idShort) {
        this.setIdShort(idShort);
    }

    public Referable(String idShort, String category, LangStrings description) {
        this.put(IDSHORT, idShort);
        this.put(CATEGORY, category);
        this.put(DESCRIPTION, description);
    }

    public static Referable createAsFacade(Map<String, Object> map, KeyElements type) {
        if (map == null) {
            return null;
        }
        if (!Referable.isValid(map)) {
            throw new MetamodelConstructionException(Referable.class, map);
        }
        Referable ret = new Referable();
        ret.setMap(map);
        ret.setElementType(type);
        return ret;
    }

    public static boolean isValid(Map<String, Object> map) {
        return map != null && map.get(IDSHORT) != null;
    }

    public static Referable createAsFacadeNonStrict(Map<String, Object> map, KeyElements type) {
        if (map == null) {
            return null;
        }
        Referable ret = new Referable();
        ret.setMap(map);
        ret.setElementType(type);
        return ret;
    }

    @Override
    public String getIdShort() {
        return (String)this.get(IDSHORT);
    }

    @Override
    public String getCategory() {
        return (String)this.get(CATEGORY);
    }

    @Override
    public LangStrings getDescription() {
        return LangStrings.createAsFacade((Collection)this.get(DESCRIPTION));
    }

    @Override
    public IReference getParent() {
        return Reference.createAsFacade((Map)this.get(PARENT));
    }

    public void setIdShort(String idShort) {
        if (!IdShortValidator.isValid(idShort)) {
            logger.warn("The passed idShort " + idShort + " is not valid! It has to satisfy the RegEx [a-zA-Z][a-zA-Z0-9_]+");
        }
        this.put(IDSHORT, idShort);
    }

    public void setCategory(String category) {
        this.put(CATEGORY, category);
    }

    public void setDescription(LangStrings description) {
        this.put(DESCRIPTION, description);
    }

    public void setParent(IReference obj) {
        this.put(PARENT, obj);
    }

    protected void setElementType(KeyElements elem) {
        this.elem = elem;
    }

    protected KeyType getKeyType() {
        return KeyType.IDSHORT;
    }

    protected String getId() {
        return this.getIdShort();
    }

    protected boolean isLocal() {
        return true;
    }

    @Override
    public IReference getReference() {
        ArrayList<IKey> keys = new ArrayList<IKey>();
        IReference parent = this.getParent();
        if (parent != null) {
            keys.addAll(parent.getKeys());
        }
        keys.add(new Key(this.elem, this.isLocal(), this.getId(), this.getKeyType()));
        return new Reference(keys);
    }
}

