/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.vab.model.VABModelMap;

public class EntityValue
extends VABModelMap<Object> {
    private EntityValue() {
    }

    public EntityValue(Collection<ISubmodelElement> statements, IReference asset) {
        this.put("statements", statements);
        this.put("asset", asset);
    }

    public static EntityValue createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        EntityValue facade = new EntityValue();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isEntityValue(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        if (!(map.get("statements") instanceof Collection) || !Reference.isReference(map.get("asset"))) {
            return false;
        }
        try {
            ((Collection)map.get("statements")).stream().forEach(SubmodelElementFacadeFactory::createSubmodelElement);
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public Collection<ISubmodelElement> getStatement() {
        Collection elements = (Collection)this.get("statements");
        return elements.stream().map(e -> SubmodelElementFacadeFactory.createSubmodelElement(e)).collect(Collectors.toList());
    }

    public IReference getAsset() {
        return Reference.createAsFacade((Map)this.get("asset"));
    }
}

