/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IAsyncInvocation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.AsyncInvocation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationCheckHelper;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationHelper;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProvider;

public class Operation
extends SubmodelElement
implements IOperation {
    public static final int DEFAULT_ASYNC_TIMEOUT = 10000;
    public static final String IN = "inputVariables";
    public static final String OUT = "outputVariables";
    public static final String INOUT = "inoutputVariables";
    public static final String INVOKABLE = "invokable";
    public static final String MODELTYPE = "Operation";
    public static final String INVOKE = "invoke";
    public static final String IS_WRAPPED_INVOKABLE = "isWrappedInvokable";

    public Operation() {
        this(new ArrayList<OperationVariable>(), new ArrayList<OperationVariable>(), new ArrayList<OperationVariable>());
    }

    public Operation(String idShort) {
        this();
        this.setIdShort(idShort);
    }

    public Operation(Collection<OperationVariable> in, Collection<OperationVariable> out, Collection<OperationVariable> inout) {
        this.putAll(new ModelType(MODELTYPE));
        this.setInputVariables(in);
        this.setOutputVariables(out);
        this.setInOutputVariables(inout);
    }

    public Operation(Collection<OperationVariable> in, Collection<OperationVariable> out, Collection<OperationVariable> inout, Function<Object[], Object> function) {
        this(in, out, inout);
        this.setInvokable(function);
    }

    public Operation(Function<Object[], Object> function) {
        this();
        this.setInvokable(function);
    }

    public static Operation createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Operation.isValid(obj)) {
            throw new MetamodelConstructionException(Operation.class, obj);
        }
        Operation ret = new Operation();
        ret.setMap(obj);
        return ret;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return SubmodelElement.isValid(obj);
    }

    public static boolean isOperation(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey(IN) && map.containsKey(OUT) && map.containsKey(INOUT);
    }

    @Override
    public Collection<IOperationVariable> getInputVariables() {
        return this.transformToOperationVariables(this.get(IN));
    }

    @Override
    public Collection<IOperationVariable> getOutputVariables() {
        return this.transformToOperationVariables(this.get(OUT));
    }

    @Override
    public Collection<IOperationVariable> getInOutputVariables() {
        return this.transformToOperationVariables(this.get(INOUT));
    }

    @Override
    public Object invoke(Object ... params) {
        return this.invokeSimple(params);
    }

    @Override
    public Object invokeSimple(Object ... simpleParams) {
        OperationCheckHelper.checkValidParameterLength(simpleParams.length, this.getIdShort(), this.getInputVariables());
        OperationCheckHelper.checkSubmodelElementExpectedTypes(simpleParams, this.getInputVariables());
        if (this.isWrappedInvokable()) {
            return this.invokeWrappedInvokableWithSimpleParameters(simpleParams);
        }
        return this.directlyInvokeSimpleInvokable(simpleParams);
    }

    private Object invokeWrappedInvokableWithSimpleParameters(Object ... simpleParams) {
        Map<String, SubmodelElement> wrappedParamMap = OperationHelper.wrapSimpleInputParametersInMap(simpleParams, this.getInputVariables());
        OperationCheckHelper.checkSubmodelElementAsParameter(wrappedParamMap, this.getInputVariables());
        SubmodelElement[] wrappedResult = this.directlyInvokeWrappedInvokable(wrappedParamMap);
        return OperationHelper.unwrapResult(wrappedResult);
    }

    @Override
    public SubmodelElement[] invoke(SubmodelElement ... elems) {
        OperationCheckHelper.checkValidParameterLength(elems.length, this.getIdShort(), this.getInputVariables());
        OperationCheckHelper.checkSubmodelElementAsParameter(elems, this.getInputVariables());
        Map<String, SubmodelElement> seMap = OperationHelper.convertSubmodelElementArrayToMap(elems);
        return this.invokeWrappedUnchecked(seMap);
    }

    @Override
    public AsyncInvocation invokeAsync(Object ... params) {
        return new AsyncInvocation(this, 10000, params);
    }

    @Override
    public IAsyncInvocation invokeAsyncWithTimeout(int timeout, Object ... params) {
        return new AsyncInvocation(this, timeout, params);
    }

    public void setInputVariables(Collection<OperationVariable> in) {
        this.put(IN, in);
    }

    public void setOutputVariables(Collection<OperationVariable> out) {
        this.put(OUT, out);
    }

    public void setInOutputVariables(Collection<OperationVariable> inOut) {
        this.put(INOUT, inOut);
    }

    public void setWrappedInvokable(Function<Map<String, SubmodelElement>, SubmodelElement[]> endpoint) {
        Function<Object[], Object> wrappedInvokable = this.prepareWrappedFunctionForVAB(endpoint);
        this.setInvokable(wrappedInvokable);
        this.put(IS_WRAPPED_INVOKABLE, Boolean.valueOf(true));
    }

    public void setWrappedInvokable(Consumer<Map<String, SubmodelElement>> consumer) {
        Consumer<Object[]> wrappedInvokable = this.prepareWrappedFunctionForVAB(consumer);
        this.setInvokable(wrappedInvokable);
        this.put(IS_WRAPPED_INVOKABLE, Boolean.valueOf(true));
    }

    public void setWrappedInvokable(Supplier<SubmodelElement[]> supplier) {
        Supplier<Object> wrappedInvokable = this.prepareWrappedFunctionForVAB(supplier);
        this.setInvokable(wrappedInvokable);
        this.put(IS_WRAPPED_INVOKABLE, Boolean.valueOf(true));
    }

    public void setInvokable(Function<Object[], Object> endpoint) {
        this.setSimpleInvokable(endpoint);
    }

    public void setInvokable(Runnable runnable) {
        this.setSimpleInvokable(runnable);
    }

    public void setInvokable(Supplier<Object> supplier) {
        this.setSimpleInvokable(supplier);
    }

    public void setInvokable(Consumer<Object[]> consumer) {
        this.setSimpleInvokable(consumer);
    }

    @Override
    public Collection<IReference> getDataSpecificationReferences() {
        return HasDataSpecification.createAsFacade(this).getDataSpecificationReferences();
    }

    @Override
    public void setDataSpecificationReferences(Collection<IReference> ref) {
        HasDataSpecification.createAsFacade(this).setDataSpecificationReferences(ref);
    }

    @Override
    public String getIdShort() {
        return Referable.createAsFacade(this, this.getKeyElement()).getIdShort();
    }

    @Override
    public String getCategory() {
        return Referable.createAsFacade(this, this.getKeyElement()).getCategory();
    }

    @Override
    public LangStrings getDescription() {
        return Referable.createAsFacade(this, this.getKeyElement()).getDescription();
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.OPERATION;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("An Operation has no value");
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("An Operation has no value");
    }

    @Override
    public Operation getLocalCopy() {
        Operation copy = new Operation();
        copy.putAll(this);
        Collection<IOperationVariable> inVars = copy.getInputVariables();
        ArrayList<OperationVariable> inVarCopy = new ArrayList<OperationVariable>();
        inVars.stream().forEach((? super T v) -> inVarCopy.add(new OperationVariable(v.getValue().getLocalCopy())));
        copy.setInputVariables(inVarCopy);
        Collection<IOperationVariable> outVars = copy.getOutputVariables();
        ArrayList<OperationVariable> outVarCopy = new ArrayList<OperationVariable>();
        outVars.stream().forEach((? super T v) -> outVarCopy.add(new OperationVariable(v.getValue().getLocalCopy())));
        copy.setOutputVariables(outVarCopy);
        Collection<IOperationVariable> inoutVars = copy.getInOutputVariables();
        ArrayList<OperationVariable> inoutVarCopy = new ArrayList<OperationVariable>();
        inoutVars.stream().forEach((? super T v) -> inoutVarCopy.add(new OperationVariable(v.getValue().getLocalCopy())));
        copy.setInOutputVariables(inoutVarCopy);
        return copy;
    }

    private void setSimpleInvokable(Object invokable) {
        this.put(INVOKABLE, invokable);
        this.put(IS_WRAPPED_INVOKABLE, Boolean.valueOf(false));
    }

    private Collection<IOperationVariable> transformToOperationVariables(Object obj) {
        if (obj instanceof Collection) {
            Collection mapCollection = (Collection)obj;
            return this.transformToOperationVariable(mapCollection);
        }
        return new ArrayList<IOperationVariable>();
    }

    private Collection<IOperationVariable> transformToOperationVariable(Collection<Map<String, Object>> mapCollection) {
        ArrayList<IOperationVariable> ret = new ArrayList<IOperationVariable>();
        for (Map<String, Object> m : mapCollection) {
            OperationVariable opVariable = OperationVariable.createAsFacade(m);
            ret.add(opVariable);
        }
        return ret;
    }

    private Object directlyInvokeSimpleInvokable(Object[] simpleParams) {
        return new VABLambdaProvider(this).invokeOperation(INVOKABLE, simpleParams);
    }

    private SubmodelElement[] invokeWrappedUnchecked(Map<String, SubmodelElement> wrappedParamMap) {
        if (this.isWrappedInvokable()) {
            return this.directlyInvokeWrappedInvokable(wrappedParamMap);
        }
        Object[] unwrappedParams = OperationHelper.unwrapInputParameters(wrappedParamMap, this.getInputVariables());
        Object unwrappedResult = this.directlyInvokeSimpleInvokable(unwrappedParams);
        return OperationHelper.wrapResult(unwrappedResult, this.getOutputVariables());
    }

    private SubmodelElement[] directlyInvokeWrappedInvokable(Map<String, SubmodelElement> wrappedParamMap) {
        return (SubmodelElement[])new VABLambdaProvider(this).invokeOperation(INVOKABLE, wrappedParamMap);
    }

    private boolean isWrappedInvokable() {
        Object isWrappedInvokable = this.get(IS_WRAPPED_INVOKABLE);
        return isWrappedInvokable != null && (Boolean)isWrappedInvokable != false;
    }

    private Function<Object[], Object> prepareWrappedFunctionForVAB(Function<Map<String, SubmodelElement>, SubmodelElement[]> wrappedFunction) {
        return elemArray -> wrappedFunction.apply((Map)elemArray[0]);
    }

    private Consumer<Object[]> prepareWrappedFunctionForVAB(Consumer<Map<String, SubmodelElement>> consumer) {
        return elemArray -> consumer.accept((Map)elemArray[0]);
    }

    private Supplier<Object> prepareWrappedFunctionForVAB(Supplier<SubmodelElement[]> supplier) {
        return () -> supplier.get();
    }
}

