/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.observing;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.observer.Observable;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.observing.ISubmodelAPIObserverV2;
import org.eclipse.basyx.submodel.restapi.observing.ObservableSubmodelAPIV2Helper;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class ObservableSubmodelAPIV2
extends Observable<ISubmodelAPIObserverV2>
implements ISubmodelAPI {
    ISubmodelAPI submodelAPI;
    private String aasServerId = "aas-server";

    public ObservableSubmodelAPIV2(ISubmodelAPI observerdAPI, String aasServerId) {
        this.submodelAPI = observerdAPI;
        this.aasServerId = aasServerId;
    }

    @Override
    public ISubmodel getSubmodel() {
        return this.submodelAPI.getSubmodel();
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        String idShortPath = elem.getIdShort();
        this.addOrReplaceSubmodelElement(idShortPath, elem);
    }

    private void addOrReplaceSubmodelElement(String idShortPath, ISubmodelElement elem) {
        try {
            this.submodelAPI.getSubmodelElement(idShortPath);
            this.submodelAPI.addSubmodelElement(idShortPath, elem);
            this.observers.stream().forEach(o -> o.elementUpdated(idShortPath, elem, this.getParentAASId(this.getSubmodel()), this.getSubmodel().getIdentification().getId(), this.aasServerId));
        }
        catch (ResourceNotFoundException e) {
            this.submodelAPI.addSubmodelElement(idShortPath, elem);
            this.observers.stream().forEach(o -> o.elementAdded(idShortPath, elem, this.getParentAASId(this.getSubmodel()), this.getSubmodel().getIdentification().getId(), this.aasServerId));
        }
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        this.addOrReplaceSubmodelElement(idShortPath, elem);
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        return this.submodelAPI.getSubmodelElement(idShortPath);
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        ISubmodelElement submodelElement = this.submodelAPI.getSubmodelElement(idShortPath);
        this.submodelAPI.deleteSubmodelElement(idShortPath);
        this.observers.stream().forEach(o -> o.elementDeleted(idShortPath, submodelElement, this.getParentAASId(this.getSubmodel()), this.getSubmodel().getIdentification().getId(), this.aasServerId));
    }

    @Override
    public Collection<IOperation> getOperations() {
        return this.submodelAPI.getOperations();
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        return this.submodelAPI.getSubmodelElements();
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        this.submodelAPI.updateSubmodelElement(idShortPath, newValue);
        ISubmodelElement elem = this.submodelAPI.getSubmodelElement(idShortPath);
        Object valueToSend = ObservableSubmodelAPIV2Helper.shouldSendEmptyValueEvent(elem) ? null : newValue;
        this.observers.stream().forEach(o -> o.elementValue(idShortPath, valueToSend, this.getParentAASId(this.getSubmodel()), this.getSubmodel().getIdentification().getId(), this.aasServerId));
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        return this.submodelAPI.getSubmodelElementValue(idShortPath);
    }

    @Override
    public Object invokeOperation(String idShortPath, Object ... params) {
        return this.submodelAPI.invokeOperation(idShortPath, params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        return this.submodelAPI.invokeAsync(idShortPath, params);
    }

    @Override
    public Object getOperationResult(String idShort, String requestId) {
        return this.submodelAPI.getOperationResult(idShort, requestId);
    }

    private String getParentAASId(ISubmodel submodel) {
        IReference parentReference = submodel.getParent();
        if (parentReference == null) {
            return null;
        }
        List<IKey> keys = parentReference.getKeys();
        if (keys != null && keys.size() > 0) {
            return keys.get(0).getValue();
        }
        return null;
    }

    @Override
    public File getSubmodelElementFile(String idShortPath) {
        return this.submodelAPI.getSubmodelElementFile(idShortPath);
    }

    @Override
    public void uploadSubmodelElementFile(String idShortPath, InputStream fileStream) {
        this.submodelAPI.uploadSubmodelElementFile(idShortPath, fileStream);
    }
}

