/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.coder.json.metaprotocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.vab.coder.json.metaprotocol.Message;
import org.eclipse.basyx.vab.coder.json.metaprotocol.MessageType;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.protocol.http.server.ExceptionToHTTPCodeMapper;

public class Result
extends LinkedHashMap<String, Object> {
    public static final String SUCCESS = "success";
    public static final String ISEXCEPTION = "isException";
    public static final String MESSAGES = "messages";
    public static final String ENTITY = "entity";
    public static final String ENTITYTYPE = "entityType";

    public Result(boolean success) {
        this(success, null, null);
    }

    public Result(boolean success, Message message) {
        this(success, null, new LinkedList<Message>(Arrays.asList(message)));
    }

    public Result(boolean success, List<Message> messages) {
        this(success, null, messages);
    }

    public Result(boolean success, Object entity, List<Message> messages) {
        this.put(SUCCESS, success);
        if (messages != null) {
            LinkedList<Message> messageslist = new LinkedList<Message>();
            for (Message msg : messages) {
                MessageType type = msg.getMessageType();
                if (type.equals((Object)MessageType.Exception)) {
                    this.put(ISEXCEPTION, true);
                }
                messageslist.add(msg);
            }
            this.put(MESSAGES, messageslist);
        }
        if (entity != null) {
            this.put(ENTITY, entity);
            this.put(ENTITYTYPE, entity.getClass().getName());
        }
    }

    public Result(Result result) {
        this(result.success(), result.getEntity(), result.getMessages());
    }

    public Result(Exception e) {
        this(false, Result.getMessageListFromException(e));
    }

    public static Result createAsFacade(Map<String, Object> map) {
        boolean success = (Boolean)map.get(SUCCESS);
        Object entity = map.get(ENTITY);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Map messageMap : (List)map.get(MESSAGES)) {
            messages.add(Message.createAsFacade(messageMap));
        }
        return new Result(success, entity, messages);
    }

    private static List<Message> getMessageListFromException(Exception e) {
        LinkedList<Message> messageList = new LinkedList<Message>();
        if (e instanceof ProviderException) {
            String code = new Integer(ExceptionToHTTPCodeMapper.mapFromException((ProviderException)e)).toString();
            Message message = new Message(MessageType.Exception, code, e.getClass().getSimpleName() + ": " + e.getMessage());
            messageList.add(message);
        }
        if (e.getCause() != null) {
            messageList.addAll(Result.getMessageListFromException((Exception)e.getCause()));
        }
        return messageList;
    }

    public Class<?> getEntityType() {
        Object entityType = this.get(ENTITYTYPE);
        if (entityType instanceof String) {
            String typeString = (String)entityType;
            try {
                return Class.forName(typeString);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public Object getEntity() {
        return this.get(ENTITY);
    }

    public boolean success() {
        return (Boolean)this.get(SUCCESS);
    }

    public boolean isException() {
        return (Boolean)this.get(ISEXCEPTION);
    }

    public List<Message> getMessages() {
        return (List)this.get(MESSAGES);
    }
}

