/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Builder;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.DeferredBuilder;
import de.iip_ecosphere.platform.support.aas.Entity;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.RelationshipElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxBlob;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDataElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxElementTranslator;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxFile;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxMultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxOperation;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReferenceElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRelationshipElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementList;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class BaSyxEntity
extends BaSyxSubmodelElement
implements Entity,
BaSyxElementTranslator.SubmodelElementsRegistrar {
    private org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity entity;
    private Map<String, Builder<?>> deferred;
    private List<SubmodelElement> statementsList;

    private BaSyxEntity() {
    }

    BaSyxEntity(org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity entity) {
        this.entity = entity;
    }

    private void createElementsStructure() {
        this.statementsList = new ArrayList<SubmodelElement>();
    }

    private void initialize() {
        if (null == this.statementsList) {
            this.createElementsStructure();
            BaSyxElementTranslator.registerSubmodelElements(this.entity.getStatements(), (BaSyxElementTranslator.SubmodelElementsRegistrar)this);
        }
    }

    org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity getEntity() {
        return this.entity;
    }

    public String getIdShort() {
        try {
            return this.entity.getIdShort();
        }
        catch (ResourceNotFoundException e) {
            return "";
        }
    }

    org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity getSubmodelElement() {
        return this.entity;
    }

    public void accept(AasVisitor visitor) {
        if (visitor.visitEntity((Entity)this)) {
            for (SubmodelElement se : visitor.sortSubmodelElements(this.statementsList)) {
                se.accept(visitor);
            }
        }
        visitor.endVisitEntity((Entity)this);
    }

    public Iterable<SubmodelElement> submodelElements() {
        return this.elements();
    }

    public Iterable<SubmodelElement> elements() {
        this.initialize();
        return this.statementsList;
    }

    public int getElementsCount() {
        this.initialize();
        return this.statementsList.size();
    }

    private Stream<SubmodelElement> elementsStream() {
        this.initialize();
        return this.statementsList.stream();
    }

    public SubmodelElement getSubmodelElement(String idShort) {
        return this.getElement(idShort);
    }

    public SubmodelElement getElement(String idShort) {
        this.initialize();
        SubmodelElement result = null;
        Optional<SubmodelElement> tmp = this.elementsStream().filter(s -> s.getIdShort().equals(idShort)).findFirst();
        result = tmp.isPresent() ? tmp.get() : null;
        return result;
    }

    public Reference createReference() {
        return new BaSyxReference(this.entity.getReference());
    }

    private <T extends SubmodelElement> T getElement(String idShort, Class<T> type) {
        SubmodelElement result = null;
        SubmodelElement tmp = this.getElement(idShort);
        if (type.isInstance(tmp)) {
            result = (SubmodelElement)type.cast(tmp);
        }
        return (T)result;
    }

    public SubmodelElementCollection getSubmodelElementCollection(String idShort) {
        return this.getElement(idShort, SubmodelElementCollection.class);
    }

    public SubmodelElementList getSubmodelElementList(String idShort) {
        return this.getElement(idShort, SubmodelElementList.class);
    }

    public Entity getEntity(String idShort) {
        return this.getElement(idShort, Entity.class);
    }

    public DataElement getDataElement(String idShort) {
        return this.getElement(idShort, DataElement.class);
    }

    public Property getProperty(String idShort) {
        return this.getElement(idShort, Property.class);
    }

    public Operation getOperation(String idShort) {
        return this.getElement(idShort, Operation.class);
    }

    public ReferenceElement getReferenceElement(String idShort) {
        return this.getElement(idShort, ReferenceElement.class);
    }

    public RelationshipElement getRelationshipElement(String idShort) {
        return this.getElement(idShort, RelationshipElement.class);
    }

    public void deleteElement(String idShort) {
        this.initialize();
        this.statementsList.removeIf(s -> s.getIdShort().equals(idShort));
        this.entity.getStatements().removeIf(s -> s.getIdShort().equals(idShort));
    }

    public Entity.EntityType getType() {
        return Tools.translate(this.entity.getEntityType());
    }

    private <T extends SubmodelElement> T add(T elt) {
        if (null == this.statementsList) {
            this.statementsList = new ArrayList<SubmodelElement>();
        }
        this.statementsList.add(elt);
        return elt;
    }

    @Override
    public <T extends SubmodelElement> T registerElement(T elt) {
        return this.add(elt);
    }

    @Override
    public BaSyxProperty register(BaSyxProperty property) {
        return this.add(property);
    }

    @Override
    public BaSyxBlob register(BaSyxBlob blob) {
        return this.add(blob);
    }

    @Override
    public BaSyxFile register(BaSyxFile file) {
        return this.add(file);
    }

    @Override
    public BaSyxMultiLanguageProperty register(BaSyxMultiLanguageProperty property) {
        return this.add(property);
    }

    @Override
    public BaSyxRelationshipElement register(BaSyxRelationshipElement relationship) {
        return this.add(relationship);
    }

    @Override
    public BaSyxEntity register(BaSyxEntity entity) {
        return this.add(entity);
    }

    @Override
    public BaSyxOperation register(BaSyxOperation operation) {
        return this.add(operation);
    }

    @Override
    public BaSyxReferenceElement register(BaSyxReferenceElement reference) {
        return this.add(reference);
    }

    @Override
    public BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection) {
        return this.add(collection);
    }

    @Override
    public <D extends org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement> BaSyxDataElement<D> register(BaSyxDataElement<D> dataElement) {
        return this.add(dataElement);
    }

    public String getSemanticId(boolean stripPrefix) {
        return Tools.translateReference(this.entity.getSemanticId(), stripPrefix);
    }

    public void setSemanticId(String semanticId) {
        IReference ref = Tools.translateReference(semanticId);
        if (ref != null) {
            this.entity.setSemanticId(ref);
        }
    }

    public static class BaSyxEntityBuilder
    extends BaSyxSubmodelElementContainerBuilder<ISubmodel>
    implements Entity.EntityBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxEntity instance;
        private org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity entity;
        private List<ISubmodelElement> statements = new ArrayList<ISubmodelElement>();
        private boolean isNew = true;

        BaSyxEntityBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort, Entity.EntityType type, Reference asset) {
            if (null == idShort || 0 == idShort.length()) {
                throw new IllegalArgumentException("idShort must be given");
            }
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxEntity();
            this.entity = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.Entity();
            this.entity.setIdShort(idShort);
            this.entity.setEntityType(Tools.translate(type));
            if (asset instanceof BaSyxReference) {
                this.entity.setAsset(((BaSyxReference)asset).getReference());
            }
        }

        protected BaSyxEntityBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, BaSyxEntity instance) {
            this.parentBuilder = parentBuilder;
            this.instance = instance;
            this.isNew = false;
            this.entity = instance.entity;
            this.instance.initialize();
        }

        public BaSyxSubmodelElementContainerBuilder<?> getParentBuilder() {
            return this.parentBuilder;
        }

        public Entity build() {
            this.instance.entity = this.entity;
            this.instance.entity.setStatements(this.statements);
            return this.parentBuilder.register(this.instance);
        }

        public Entity.EntityBuilder setSemanticId(String refValue) {
            IReference ref = Tools.translateReference(refValue);
            if (ref != null) {
                this.entity.setSemanticId(ref);
            }
            return this;
        }

        public Entity.EntityBuilder setDescription(LangString ... description) {
            this.entity.setDescription(Tools.translate(description));
            return this;
        }

        @Override
        public Reference createReference() {
            return new BaSyxReference(this.entity.getReference());
        }

        public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubmodelElementCollectionBuilder(String idShort) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder result = (SubmodelElementCollection.SubmodelElementCollectionBuilder)DeferredBuilder.getDeferred((String)idShort, SubmodelElementCollection.SubmodelElementCollectionBuilder.class, this.instance.deferred);
            if (null == result) {
                SubmodelElementCollection sub = this.instance.getSubmodelElementCollection(idShort);
                result = null == sub ? new BaSyxSubmodelElementCollection.BaSyxSubmodelElementCollectionBuilder(this, idShort, false, false) : new BaSyxSubmodelElementCollection.BaSyxSubmodelElementCollectionBuilder(this, (BaSyxSubmodelElementCollection)sub);
            }
            return result;
        }

        public SubmodelElementList.SubmodelElementListBuilder createSubmodelElementListBuilder(String idShort) {
            SubmodelElementList.SubmodelElementListBuilder result = (SubmodelElementList.SubmodelElementListBuilder)DeferredBuilder.getDeferred((String)idShort, SubmodelElementList.SubmodelElementListBuilder.class, this.instance.deferred);
            if (null == result) {
                SubmodelElementList sub = this.instance.getSubmodelElementList(idShort);
                result = null == sub ? new BaSyxSubmodelElementList.BaSyxSubmodelElementListBuilder(this, idShort) : new BaSyxSubmodelElementList.BaSyxSubmodelElementListBuilder(this, (BaSyxSubmodelElementList)sub);
            }
            return result;
        }

        public SubmodelElementContainerBuilder createSubmodelElementContainerBuilder(String idShort) {
            SubmodelElement sub = this.instance.getSubmodelElement(idShort);
            Object result = sub instanceof SubmodelElementList ? this.createSubmodelElementListBuilder(idShort) : this.createSubmodelElementCollectionBuilder(idShort);
            return result;
        }

        public Aas.AasBuilder getAasBuilder() {
            return this.parentBuilder.getAasBuilder();
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean hasElement(String idShort) {
            return this.instance.getElement(idShort) != null;
        }

        @Override
        protected AbstractSubmodel<ISubmodel> getInstance() {
            return null;
        }

        @Override
        protected String getIdShort() {
            return this.entity.getIdShort();
        }

        @Override
        protected BaSyxFile register(BaSyxFile file) {
            this.statements.add(file.getSubmodelElement());
            return this.instance.add(file);
        }

        @Override
        protected BaSyxBlob register(BaSyxBlob blob) {
            this.statements.add(blob.getSubmodelElement());
            return this.instance.add(blob);
        }

        @Override
        protected BaSyxOperation register(BaSyxOperation operation) {
            this.statements.add((ISubmodelElement)operation.getSubmodelElement());
            return this.instance.add(operation);
        }

        @Override
        protected BaSyxProperty register(BaSyxProperty property) {
            this.statements.add(property.getSubmodelElement());
            return this.instance.add(property);
        }

        @Override
        protected BaSyxMultiLanguageProperty register(BaSyxMultiLanguageProperty property) {
            this.statements.add(property.getSubmodelElement());
            return this.instance.add(property);
        }

        @Override
        protected BaSyxRelationshipElement register(BaSyxRelationshipElement relationship) {
            this.statements.add(relationship.getSubmodelElement());
            return this.instance.add(relationship);
        }

        @Override
        protected BaSyxEntity register(BaSyxEntity entity) {
            this.statements.add((ISubmodelElement)entity.getSubmodelElement());
            return this.instance.add(entity);
        }

        @Override
        protected BaSyxReferenceElement register(BaSyxReferenceElement reference) {
            this.statements.add((ISubmodelElement)reference.getSubmodelElement());
            return this.instance.add(reference);
        }

        public Entity.EntityBuilder setEntityType(Entity.EntityType type) {
            this.entity.setEntityType(Tools.translate(type));
            return this;
        }

        public Entity.EntityBuilder setAsset(Reference asset) {
            if (asset instanceof BaSyxReference) {
                this.entity.setAsset(((BaSyxReference)asset).getReference());
            }
            return this;
        }

        public Entity.EntityBuilder rbac(AuthenticationDescriptor auth, AuthenticationDescriptor.Role role, AuthenticationDescriptor.RbacAction ... actions) {
            return (Entity.EntityBuilder)AuthenticationDescriptor.elementRbac((Object)this, (AuthenticationDescriptor)auth, (AuthenticationDescriptor.Role)role, (String)this.parentBuilder.composeRbacPath(this.entity.getIdShort()), (AuthenticationDescriptor.RbacAction[])actions);
        }

        public Entity.EntityBuilder rbac(AuthenticationDescriptor auth) {
            return this;
        }
    }
}

