/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.xml.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.basyx.aas.factory.xml.api.parts.ViewXMLConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.IConceptDictionary;
import org.eclipse.basyx.aas.metamodel.api.parts.IView;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.aas.metamodel.map.parts.ConceptDictionary;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.HasDataSpecificationXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.IdentifiableXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.ReferableXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AssetAdministrationShellXMLConverter {
    public static final String ASSET_ADMINISTRATION_SHELLS = "aas:assetAdministrationShells";
    public static final String ASSET_ADMINISTRATION_SHELL = "aas:assetAdministrationShell";
    public static final String DERIVED_FROM = "aas:derivedFrom";
    public static final String ASSET_REF = "aas:assetRef";
    public static final String SUBMODEL_REFS = "aas:submodelRefs";
    public static final String SUBMODEL_REF = "aas:submodelRef";
    public static final String CONCEPT_DICTIONARIES = "aas:conceptDictionaries";
    public static final String CONCEPT_DICTIONARY = "aas:conceptDictionary";
    public static final String CONCEPT_DESCRIPTION_REFS = "aas:conceptDescriptionRefs";
    public static final String CONCEPT_DESCRIPTION_REF = "aas:conceptDescriptionRef";

    public static List<IAssetAdministrationShell> parseAssetAdministrationShells(Map<String, Object> xmlAASObject, Collection<IConceptDescription> conceptDescriptions, Collection<IAsset> assets) {
        if (xmlAASObject == null) {
            return Collections.emptyList();
        }
        ArrayList<IAssetAdministrationShell> aasList = new ArrayList<IAssetAdministrationShell>();
        List<Map<String, Object>> xmlAASs = XMLHelper.getList(xmlAASObject.get(ASSET_ADMINISTRATION_SHELL));
        for (Map<String, Object> xmlAAS : xmlAASs) {
            AssetAdministrationShell adminShell = new AssetAdministrationShell();
            IdentifiableXMLConverter.populateIdentifiable(xmlAAS, Identifiable.createAsFacadeNonStrict(adminShell, KeyElements.ASSETADMINISTRATIONSHELL));
            HasDataSpecificationXMLConverter.populateHasDataSpecification(xmlAAS, HasDataSpecification.createAsFacade(adminShell));
            Collection<IView> views = ViewXMLConverter.parseViews(xmlAAS);
            Collection<IConceptDictionary> conceptDictionary = AssetAdministrationShellXMLConverter.parseConceptDictionaries(xmlAAS, conceptDescriptions);
            Map xmlAssetRef = (Map)xmlAAS.get(ASSET_REF);
            Reference assetRef = ReferenceXMLConverter.parseReference(xmlAssetRef);
            Map xmlDerivedFrom = (Map)xmlAAS.get(DERIVED_FROM);
            Reference derivedFrom = ReferenceXMLConverter.parseReference(xmlDerivedFrom);
            adminShell.setDerivedFrom(derivedFrom);
            adminShell.setViews(views);
            adminShell.setConceptDictionary(conceptDictionary);
            adminShell.setAssetReference(assetRef);
            Collection<IReference> submodelRefs = AssetAdministrationShellXMLConverter.parseSubmodelRefs(xmlAAS);
            adminShell.setSubmodelReferences(submodelRefs);
            Asset asset = AssetAdministrationShellXMLConverter.parseAsset(assets, assetRef);
            if (asset != null) {
                adminShell.setAsset(asset);
            }
            aasList.add(adminShell);
        }
        return aasList;
    }

    private static Collection<IReference> parseSubmodelRefs(Map<String, Object> xmlObject) {
        HashSet<IReference> refSet = new HashSet<IReference>();
        Map refMap = (Map)xmlObject.get(SUBMODEL_REFS);
        if (refMap == null) {
            return new HashSet<IReference>();
        }
        List<Map<String, Object>> xmlKeyList = XMLHelper.getList(refMap.get(SUBMODEL_REF));
        for (Map<String, Object> xmlKey : xmlKeyList) {
            refSet.add(ReferenceXMLConverter.parseReference(xmlKey));
        }
        return refSet;
    }

    private static Collection<IConceptDictionary> parseConceptDictionaries(Map<String, Object> xmlConceptDescriptionRefsObject, Collection<IConceptDescription> conceptDescriptions) {
        HashSet<IConceptDictionary> conceptDictionarySet = new HashSet<IConceptDictionary>();
        if (xmlConceptDescriptionRefsObject == null) {
            return conceptDictionarySet;
        }
        Map xmlConceptDictionaries = (Map)xmlConceptDescriptionRefsObject.get(CONCEPT_DICTIONARIES);
        if (xmlConceptDictionaries == null) {
            return conceptDictionarySet;
        }
        List<Map<String, Object>> xmlConceptDictionaryList = XMLHelper.getList(xmlConceptDictionaries.get(CONCEPT_DICTIONARY));
        for (Map<String, Object> xmlConceptDictionary : xmlConceptDictionaryList) {
            ConceptDictionary conceptDictionary = new ConceptDictionary();
            ReferableXMLConverter.populateReferable(xmlConceptDictionary, Referable.createAsFacadeNonStrict(conceptDictionary, KeyElements.CONCEPTDICTIONARY));
            Map xmlConceptDescriptionRefs = (Map)xmlConceptDictionary.get(CONCEPT_DESCRIPTION_REFS);
            HashSet<IReference> referenceSet = new HashSet<IReference>();
            List<Map<String, Object>> xmlConceptDescriptionRefsList = XMLHelper.getList(xmlConceptDescriptionRefs.get(CONCEPT_DESCRIPTION_REF));
            for (Map<String, Object> xmlConceptDescriptionRef : xmlConceptDescriptionRefsList) {
                referenceSet.add(ReferenceXMLConverter.parseReference(xmlConceptDescriptionRef));
            }
            conceptDictionary.setConceptDescriptions(AssetAdministrationShellXMLConverter.getConceptDescriptions(referenceSet, conceptDescriptions));
            conceptDictionarySet.add(conceptDictionary);
        }
        return conceptDictionarySet;
    }

    private static Collection<IConceptDescription> getConceptDescriptions(Collection<IReference> referenceSet, Collection<IConceptDescription> conceptDescriptions) {
        ArrayList<IConceptDescription> result = new ArrayList<IConceptDescription>();
        for (IReference ref : referenceSet) {
            IKey firstKey;
            if (ref.getKeys() == null || ref.getKeys().isEmpty() || (firstKey = ref.getKeys().iterator().next()).getType() != KeyElements.CONCEPTDESCRIPTION || !firstKey.isLocal()) continue;
            for (IConceptDescription description : conceptDescriptions) {
                if (!description.getIdentification().getId().equals(firstKey.getValue())) continue;
                result.add(description);
            }
        }
        return result;
    }

    public static Element buildAssetAdministrationShellsXML(Document document, Collection<IAssetAdministrationShell> assetAdministrationShells) {
        Element root = document.createElement(ASSET_ADMINISTRATION_SHELLS);
        ArrayList<Element> xmlAASList = new ArrayList<Element>();
        for (IAssetAdministrationShell aas : assetAdministrationShells) {
            Element aasRoot = document.createElement(ASSET_ADMINISTRATION_SHELL);
            IdentifiableXMLConverter.populateIdentifiableXML(document, aasRoot, aas);
            HasDataSpecificationXMLConverter.populateHasDataSpecificationXML(document, aasRoot, aas);
            AssetAdministrationShellXMLConverter.buildDerivedFrom(document, aasRoot, aas);
            AssetAdministrationShellXMLConverter.buildAssetRef(document, aasRoot, aas);
            AssetAdministrationShellXMLConverter.buildSubmodelRef(document, aasRoot, aas);
            Collection<IView> views = aas.getViews();
            Element buildViews = ViewXMLConverter.buildViewsXML(document, views);
            aasRoot.appendChild(buildViews);
            aasRoot.appendChild(AssetAdministrationShellXMLConverter.buildConceptDictionary(document, aas));
            xmlAASList.add(aasRoot);
        }
        for (Element element : xmlAASList) {
            root.appendChild(element);
        }
        return root;
    }

    private static void buildDerivedFrom(Document document, Element root, IAssetAdministrationShell aas) {
        IReference derivedFrom = aas.getDerivedFrom();
        if (derivedFrom != null) {
            Element derivedFromRoot = document.createElement(DERIVED_FROM);
            derivedFromRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, derivedFrom));
            root.appendChild(derivedFromRoot);
        }
    }

    private static void buildAssetRef(Document document, Element root, IAssetAdministrationShell aas) {
        IReference assetRef = aas.getAssetReference();
        if (assetRef != null) {
            Element assetrefRoot = document.createElement(ASSET_REF);
            assetrefRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, assetRef));
            root.appendChild(assetrefRoot);
        }
    }

    private static void buildSubmodelRef(Document document, Element root, IAssetAdministrationShell aas) {
        Collection<IReference> submodelRef = aas.getSubmodelReferences();
        if (submodelRef != null && !submodelRef.isEmpty()) {
            Element submodelRefsRoot = document.createElement(SUBMODEL_REFS);
            for (IReference ref : submodelRef) {
                Element submodelRefRoot = document.createElement(SUBMODEL_REF);
                submodelRefsRoot.appendChild(submodelRefRoot);
                submodelRefRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, ref));
            }
            root.appendChild(submodelRefsRoot);
        }
    }

    private static Element buildConceptDictionary(Document document, IAssetAdministrationShell aas) {
        Collection<IConceptDictionary> conceptDicionary = aas.getConceptDictionary();
        Element conceptDicts = document.createElement(CONCEPT_DICTIONARIES);
        for (IConceptDictionary iConceptDictionary : conceptDicionary) {
            Element conceptDict = document.createElement(CONCEPT_DICTIONARY);
            Element concDescRoot = document.createElement(CONCEPT_DESCRIPTION_REFS);
            if (iConceptDictionary.getIdShort() != null) {
                Element idShort = document.createElement("aas:idShort");
                idShort.appendChild(document.createTextNode(iConceptDictionary.getIdShort()));
                conceptDict.appendChild(idShort);
            }
            conceptDict.appendChild(concDescRoot);
            conceptDicts.appendChild(conceptDict);
            Collection<IReference> conceptDescriptionRef = iConceptDictionary.getConceptDescriptionReferences();
            for (IReference ref : conceptDescriptionRef) {
                if (ref == null) continue;
                Element conceptDescriptionRefRoot = document.createElement(CONCEPT_DESCRIPTION_REF);
                concDescRoot.appendChild(conceptDescriptionRefRoot);
                conceptDescriptionRefRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, ref));
            }
        }
        return conceptDicts;
    }

    private static Asset parseAsset(Collection<IAsset> assets, Reference assetRef) {
        if (assetRef == null) {
            return null;
        }
        Optional<IAsset> optionalAsset = assets.stream().filter(asset -> AssetAdministrationShellXMLConverter.isReferenced(asset, assetRef)).findAny();
        if (optionalAsset.isEmpty()) {
            return null;
        }
        return (Asset)optionalAsset.get();
    }

    private static boolean isReferenced(IAsset asset, Reference assetReference) {
        Optional<IKey> optionalKey = assetReference.getKeys().stream().filter(key -> AssetAdministrationShellXMLConverter.hasMatchingAsset(asset, key)).findAny();
        return optionalKey.isPresent();
    }

    private static boolean hasMatchingAsset(IAsset asset, IKey key) {
        return key.getValue().equals(asset.getIdentification().getId());
    }
}

