/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.mqtt;

import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregatorFactory;
import org.eclipse.basyx.aas.aggregator.observing.ObservableAASAggregatorV2;
import org.eclipse.basyx.extensions.aas.aggregator.mqtt.MqttV2AASAggregatorObserver;
import org.eclipse.basyx.extensions.aas.aggregator.mqtt.MqttV2AASAggregatorTopicFactory;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttV2DecoratingAASAggregatorFactory
implements IAASAggregatorFactory {
    private IAASAggregatorFactory apiFactory;
    private MqttClient client;
    private String aasServerId;
    private MqttV2AASAggregatorTopicFactory topicFactory;

    public MqttV2DecoratingAASAggregatorFactory(IAASAggregatorFactory factoryToBeDecorated, MqttClient client, String aasServerId, MqttV2AASAggregatorTopicFactory topicFactory) {
        this.apiFactory = factoryToBeDecorated;
        this.client = client;
        this.aasServerId = aasServerId;
        this.topicFactory = topicFactory;
    }

    @Override
    public IAASAggregator create() {
        try {
            IAASAggregator aggregator = this.apiFactory.create();
            ObservableAASAggregatorV2 observedAASAggregator = new ObservableAASAggregatorV2(aggregator, this.aasServerId);
            MqttV2AASAggregatorObserver observer = new MqttV2AASAggregatorObserver(this.client, this.topicFactory);
            observedAASAggregator.addObserver(observer);
            return observedAASAggregator;
        }
        catch (MqttException exception) {
            throw new ProviderException(exception);
        }
    }
}

