/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.delegation;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IConstraint;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IQualifier;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifier;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.AASLambdaPropertyHelper;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.ConnectorFactory;

public class PropertyDelegationManager {
    private static final String DELEGATION_TYPE = "delegatedTo";
    private ConnectorFactory connectorProvider;

    public PropertyDelegationManager(ConnectorFactory connectorProvider) {
        this.connectorProvider = connectorProvider;
    }

    public void handleSubmodel(ISubmodel submodel) {
        submodel.getSubmodelElements().values().stream().map(SubmodelElement.class::cast).forEach(this::handleSubmodelElement);
    }

    public void handleSubmodelElement(SubmodelElement submodelElement) {
        if (Property.isProperty(submodelElement)) {
            this.handleProperty(Property.createAsFacade(submodelElement));
        } else if (SubmodelElementCollection.isSubmodelElementCollection(submodelElement)) {
            this.handeSubmodelElementCollection(SubmodelElementCollection.createAsFacade(submodelElement));
        }
    }

    public static IQualifier createDelegationQualifier(String delegationUrl) {
        Qualifier qualifier = new Qualifier(DELEGATION_TYPE, ValueType.String);
        qualifier.setValue(delegationUrl);
        return qualifier;
    }

    public static boolean isDelegationQualifier(IConstraint iConstraint) {
        return iConstraint instanceof Qualifier && ((Qualifier)iConstraint).getType().equals(DELEGATION_TYPE);
    }

    private void handeSubmodelElementCollection(SubmodelElementCollection smc) {
        smc.getSubmodelElements().values().stream().map(SubmodelElement.class::cast).forEach(this::handleSubmodelElement);
    }

    private void handleProperty(Property property) {
        Collection<IConstraint> qualifiers = property.getQualifiers();
        Optional<IConstraint> optionalConstraint = qualifiers.stream().filter(PropertyDelegationManager::isDelegationQualifier).findAny();
        if (optionalConstraint.isEmpty()) {
            return;
        }
        Qualifier delegationQualifier = (Qualifier)optionalConstraint.get();
        this.configureDelegationProperty(property, delegationQualifier);
    }

    private void configureDelegationProperty(SubmodelElement submodelElement, IConstraint iConstraint) {
        String delegatedTo = ((Qualifier)iConstraint).getValue().toString();
        AASLambdaPropertyHelper.setLambdaValue((Property)submodelElement, () -> this.getPropertyValue(delegatedTo), null);
    }

    private Object getPropertyValue(String delegatedTo) {
        try {
            URL url = new URL(delegatedTo);
            String address = this.createAddressFromURL(url);
            IModelProvider connector = this.connectorProvider.create(address);
            return connector.getValue(url.getPath());
        }
        catch (MalformedURLException e) {
            throw new ProviderException(e);
        }
    }

    private String createAddressFromURL(URL url) {
        return url.getProtocol() + "://" + url.getHost() + ":" + (url.getPort() != -1 ? Integer.toString(url.getPort()) : "");
    }
}

