/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.mqtt;

import org.eclipse.basyx.extensions.submodel.mqtt.MqttV2SubmodelAPIObserver;
import org.eclipse.basyx.extensions.submodel.mqtt.MqttV2SubmodelAPITopicFactory;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.submodel.restapi.observing.ObservableSubmodelAPIV2;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttV2DecoratingSubmodelAPIFactory
implements ISubmodelAPIFactory {
    private ISubmodelAPIFactory apiFactory;
    private MqttClient client;
    private String aasServerId;
    private MqttV2SubmodelAPITopicFactory topicFactory;

    public MqttV2DecoratingSubmodelAPIFactory(ISubmodelAPIFactory factoryToBeDecorated, MqttClient client, String aasServerId, MqttV2SubmodelAPITopicFactory topicFactory) {
        this.apiFactory = factoryToBeDecorated;
        this.client = client;
        this.aasServerId = aasServerId;
        this.topicFactory = topicFactory;
    }

    @Override
    public ISubmodelAPI getSubmodelAPI(Submodel submodel) {
        try {
            ObservableSubmodelAPIV2 observedAPI = new ObservableSubmodelAPIV2(this.apiFactory.create(submodel), this.aasServerId);
            MqttV2SubmodelAPIObserver mqttSubmodelAPIObserver = new MqttV2SubmodelAPIObserver(this.client, this.topicFactory);
            observedAPI.addObserver(mqttSubmodelAPIObserver);
            return observedAPI;
        }
        catch (MqttException e) {
            throw new ProviderException(e);
        }
    }
}

