/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.qualifier;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IAdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.AdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;

public class Identifiable
extends Referable
implements IIdentifiable {
    public static final String ADMINISTRATION = "administration";
    public static final String IDENTIFICATION = "identification";

    public Identifiable() {
        this.putAll(new Referable());
        this.put(IDENTIFICATION, new Identifier());
    }

    public Identifiable(String idShort, IIdentifier identification) {
        super(idShort);
        this.setIdentification(identification.getIdType(), identification.getId());
    }

    public Identifiable(String version, String revision, String idShort, String category, LangStrings description, IdentifierType idType, String id) {
        this.putAll(new Referable(idShort, category, description));
        this.put(ADMINISTRATION, new AdministrativeInformation(version, revision));
        this.put(IDENTIFICATION, new Identifier(idType, id));
    }

    public static Identifiable createAsFacade(Map<String, Object> map, KeyElements type) {
        if (map == null) {
            return null;
        }
        if (!Identifiable.isValid(map)) {
            throw new MetamodelConstructionException(Identifiable.class, map);
        }
        Identifiable ret = new Identifiable();
        ret.setMap(map);
        ret.setElementType(type);
        return ret;
    }

    public static boolean isValid(Map<String, Object> map) {
        return Referable.isValid(map) && map.containsKey(IDENTIFICATION) && Identifier.isValid((Map)map.get(IDENTIFICATION));
    }

    public static Identifiable createAsFacadeNonStrict(Map<String, Object> map, KeyElements type) {
        if (map == null) {
            return null;
        }
        Identifiable ret = new Identifiable();
        ret.setMap(map);
        ret.setElementType(type);
        return ret;
    }

    @Override
    public IAdministrativeInformation getAdministration() {
        return AdministrativeInformation.createAsFacade((Map)this.get(ADMINISTRATION));
    }

    @Override
    public IIdentifier getIdentification() {
        return Identifier.createAsFacade((Map)this.get(IDENTIFICATION));
    }

    public void setAdministration(AdministrativeInformation info) {
        this.put(ADMINISTRATION, info);
    }

    public void setIdentification(IdentifierType idType, String id) {
        this.put(IDENTIFICATION, new Identifier(idType, id));
    }

    @Override
    protected String getId() {
        return this.getIdentification().getId();
    }

    @Override
    protected KeyType getKeyType() {
        return KeyType.fromString(this.getIdentification().getIdType().toString());
    }

    @Override
    protected boolean isLocal() {
        return true;
    }
}

