/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.coder.json.metaprotocol;

import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.vab.coder.json.metaprotocol.IMetaProtocolHandler;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.protocol.http.server.ExceptionToHTTPCodeMapper;

public class MetaprotocolHandler
implements IMetaProtocolHandler {
    protected GSONTools serializer = null;

    public MetaprotocolHandler() {
        this.serializer = new GSONTools(new DefaultTypeFactory());
    }

    public MetaprotocolHandler(GSONToolsFactory factory) {
        this.serializer = new GSONTools(factory);
    }

    @Override
    public Object deserialize(String message) throws ProviderException {
        Object gsonObj = this.serializer.deserialize(message);
        Object result = null;
        if (gsonObj instanceof Map) {
            Map responseMap = (Map)gsonObj;
            result = this.handleResult(responseMap);
        } else {
            result = gsonObj;
        }
        return result;
    }

    private Object handleResult(Map<String, Object> responseMap) throws ProviderException {
        if (!responseMap.containsKey("success")) {
            return responseMap;
        }
        Collection messages = (Collection)responseMap.get("messages");
        if (messages == null) {
            throw new ProviderException("Unknown error occured: Success entry is indicating an error but no message was attached");
        }
        Map first = (Map)messages.iterator().next();
        String code = (String)first.get("code");
        String text = (String)first.get("text");
        throw MetaprotocolHandler.getExceptionFromCode(code, text);
    }

    public static ProviderException getExceptionFromCode(String code, String text) {
        int exceptionCode = Integer.parseInt(code);
        return ExceptionToHTTPCodeMapper.mapToException(exceptionCode, text);
    }
}

