/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.server;

import java.util.List;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.vab.coder.json.metaprotocol.Message;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceAlreadyExistsException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class ExceptionToHTTPCodeMapper {
    public static int mapFromException(ProviderException e) {
        if (e instanceof MalformedRequestException) {
            return 400;
        }
        if (e instanceof NotAuthorizedException) {
            return 403;
        }
        if (e instanceof ResourceAlreadyExistsException) {
            return 422;
        }
        if (e instanceof ResourceNotFoundException) {
            return 404;
        }
        return 500;
    }

    public static ProviderException mapToException(int statusCode, String text) {
        switch (statusCode) {
            case 400: {
                return new MalformedRequestException(text);
            }
            case 403: {
                return new NotAuthorizedException(text);
            }
            case 422: {
                return new ResourceAlreadyExistsException(text);
            }
            case 404: {
                return new ResourceNotFoundException(text);
            }
        }
        return new ProviderException(text);
    }

    public static ProviderException mapToException(int statusCode, List<Message> messages) {
        switch (statusCode) {
            case 400: {
                return new MalformedRequestException(messages);
            }
            case 403: {
                return new NotAuthorizedException(messages);
            }
            case 422: {
                return new ResourceAlreadyExistsException(messages);
            }
            case 404: {
                return new ResourceNotFoundException(messages);
            }
        }
        return new ProviderException(messages);
    }
}

