/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.server;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.basyx.vab.coder.json.provider.JSONProvider;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.server.BasysHTTPServlet;
import org.eclipse.basyx.vab.protocol.http.server.ExceptionToHTTPCodeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VABHTTPInterface<ModelProvider extends IModelProvider>
extends BasysHTTPServlet {
    private static Logger logger = LoggerFactory.getLogger(VABHTTPInterface.class);
    private static final long serialVersionUID = 1L;
    protected JSONProvider<ModelProvider> providerBackend = null;

    public VABHTTPInterface(ModelProvider provider) {
        this.providerBackend = new JSONProvider<ModelProvider>(provider);
    }

    public ModelProvider getModelProvider() {
        return this.providerBackend.getBackendReference();
    }

    protected void sendJSONResponse(String path, PrintWriter outputStream, Object jsonValue) {
        outputStream.write(jsonValue.toString());
        outputStream.flush();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String path = this.extractPath(req);
            if (this.isFileAccessPath(path)) {
                this.providerBackend.processBaSysFileGet(path, resp);
                return;
            }
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(200);
            this.providerBackend.processBaSysGet(path, (OutputStream)resp.getOutputStream());
        }
        catch (ProviderException e) {
            int httpCode = ExceptionToHTTPCodeMapper.mapFromException(e);
            resp.setStatus(httpCode);
            logger.debug("Exception in HTTP-GET. Response-code: " + httpCode, (Throwable)e);
        }
    }

    private boolean isFileAccessPath(String path) {
        return VABPathTools.getLastElement(path).equals("File");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String path = this.extractPath(req);
            String serValue = this.extractSerializedValue(req);
            logger.trace("DoPut: {}", (Object)serValue);
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(200);
            this.providerBackend.processBaSysSet(path, serValue.toString(), (OutputStream)resp.getOutputStream());
        }
        catch (ProviderException e) {
            int httpCode = ExceptionToHTTPCodeMapper.mapFromException(e);
            resp.setStatus(httpCode);
            logger.debug("Exception in HTTP-PUT. Response-code: " + httpCode, (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String path = this.extractPath(req);
            this.setPostResponseHeader(resp);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                this.handleMultipartFormDataRequest(req, path, resp);
            } else {
                this.handleJSONPostRequest(req, path, resp);
            }
        }
        catch (ProviderException e) {
            int httpCode = ExceptionToHTTPCodeMapper.mapFromException(e);
            resp.setStatus(httpCode);
            logger.debug("Exception in HTTP-POST. Response-code: " + httpCode, (Throwable)e);
        }
    }

    @Override
    protected void doPatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String path = this.extractPath(req);
            String serValue = this.extractSerializedValue(req);
            logger.trace("DoPatch: {}", (Object)serValue);
            resp.setStatus(200);
            this.providerBackend.processBaSysDelete(path, serValue, (OutputStream)resp.getOutputStream());
        }
        catch (ProviderException e) {
            int httpCode = ExceptionToHTTPCodeMapper.mapFromException(e);
            resp.setStatus(httpCode);
            logger.debug("Exception in HTTP-PATCH. Response-code: " + httpCode, (Throwable)e);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String path = this.extractPath(req);
            String nullParam = "";
            resp.setStatus(200);
            this.providerBackend.processBaSysDelete(path, nullParam, (OutputStream)resp.getOutputStream());
        }
        catch (ProviderException e) {
            int httpCode = ExceptionToHTTPCodeMapper.mapFromException(e);
            resp.setStatus(httpCode);
            logger.debug("Exception in HTTP-DELETE. Response-code: " + httpCode, (Throwable)e);
        }
    }

    private String extractPath(HttpServletRequest req) throws UnsupportedEncodingException {
        String contextPath;
        String uri = req.getRequestURI();
        String nUri = "/" + VABPathTools.stripSlashes(uri);
        if (nUri.startsWith(contextPath = req.getContextPath()) && nUri.length() > this.getEnvironmentPathSize(req) - 1) {
            Object path = nUri.substring(this.getEnvironmentPathSize(req));
            String extractedParameters = this.extractParameters(req);
            path = VABPathTools.stripSlashes((String)path);
            path = extractedParameters.isEmpty() ? (String)path + "/" : (String)path + extractedParameters;
            return path;
        }
        throw new MalformedRequestException("The passed path " + uri + " is not a possbile path for this server.");
    }

    private String extractParameters(HttpServletRequest req) {
        Enumeration parameterNames = req.getParameterNames();
        ArrayList<String> parameters = new ArrayList<String>();
        while (parameterNames.hasMoreElements()) {
            StringBuilder ret = new StringBuilder();
            String paramName = (String)parameterNames.nextElement();
            ret.append(paramName);
            ret.append("=");
            String[] paramValues = req.getParameterValues(paramName);
            for (int i = 0; i < paramValues.length; ++i) {
                ret.append(paramValues[i]);
            }
            parameters.add(ret.toString());
        }
        if (parameters.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("&");
        parameters.stream().forEach(s -> joiner.add((CharSequence)s));
        return "?" + joiner.toString();
    }

    private int getEnvironmentPathSize(HttpServletRequest req) {
        return req.getContextPath().length() + req.getServletPath().length();
    }

    private String extractSerializedValue(HttpServletRequest req) throws IOException {
        return this.getByteSource(req).asCharSource(Charsets.UTF_8).read();
    }

    private Collection<InputStream> extractInputStreams(HttpServletRequest req) throws IOException, ServletException {
        ArrayList<InputStream> fileStreams = new ArrayList<InputStream>();
        try {
            List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(req);
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                fileStreams.add(item.getInputStream());
            }
        }
        catch (FileUploadException e) {
            throw new ServletException("Cannot parse multipart request.", (Throwable)e);
        }
        return fileStreams;
    }

    private ByteSource getByteSource(final HttpServletRequest req) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return req.getInputStream();
            }
        };
    }

    private void setPostResponseHeader(HttpServletResponse resp) {
        resp.setStatus(201);
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
    }

    private void handleMultipartFormDataRequest(HttpServletRequest req, String path, HttpServletResponse resp) throws IOException, ServletException {
        Collection<InputStream> fileStreams = this.extractInputStreams(req);
        for (InputStream fileStream : fileStreams) {
            this.providerBackend.processBaSysUpload(path, fileStream, resp.getOutputStream());
            fileStream.close();
        }
    }

    private void handleJSONPostRequest(HttpServletRequest req, String path, HttpServletResponse resp) throws IOException {
        String serValue = this.extractSerializedValue(req);
        logger.trace("DoPost: {}", (Object)serValue);
        if (VABPathTools.isOperationInvokationPath(path)) {
            this.providerBackend.processBaSysInvoke(path, serValue, (OutputStream)resp.getOutputStream());
        } else {
            this.providerBackend.processBaSysCreate(path, serValue, (OutputStream)resp.getOutputStream());
        }
    }
}

