/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.factory.propertymap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.map.descriptor.CustomId;
import org.eclipse.basyx.components.factory.propertymap.PropertyMapConstantsHelper;
import org.eclipse.basyx.components.propertymap.PropertyMapHelper;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;

public class PropertyMapBasedSubmodelFactory {
    public static final String PROPERTIES = "properties";
    private final Map<String, Property> propertyMap;

    public PropertyMapBasedSubmodelFactory(Map<String, Property> properties) {
        this.propertyMap = properties;
    }

    public Submodel create(Map<String, String> submodelMap) {
        String smId = PropertyMapConstantsHelper.getIdValue(submodelMap);
        String smIdShort = PropertyMapConstantsHelper.getIdShort(submodelMap);
        List<Property> properties = this.getProperties(submodelMap);
        Submodel sm = new Submodel(smIdShort, (IIdentifier)new CustomId(smId));
        properties.stream().forEach(p -> sm.addSubmodelElement((ISubmodelElement)p));
        return sm;
    }

    private List<Property> getProperties(Map<String, String> smMap) {
        String propertyNames = this.getPropertyNames(smMap);
        List<String> propertyNamesList = this.getPropertyNamesAsList(propertyNames);
        return this.getPropertiesFromNameList(propertyNamesList);
    }

    private String getPropertyNames(Map<String, String> smMap) {
        return smMap.get(PROPERTIES);
    }

    private List<Property> getPropertiesFromNameList(List<String> propertyNames) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (String propName : propertyNames) {
            Property toAdd = this.getProperty(propName);
            ret.add(toAdd);
        }
        return ret;
    }

    private Property getProperty(String propName) throws RuntimeException {
        if (!this.propertyMap.containsKey(propName)) {
            throw new RuntimeException("Property with name " + propName + " could not be resolved");
        }
        return this.propertyMap.get(propName);
    }

    private List<String> getPropertyNamesAsList(String names) {
        return PropertyMapHelper.getListFromStringList(names);
    }
}

