/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.internal.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.model.Filters;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;

public class MongoDBFileHelper {
    private MongoDBFileHelper() {
    }

    public static String updateFileInDB(MongoClient client, BaSyxMongoDBConfiguration config, String submodelId, InputStream newValue, ISubmodelElement element, String idShortPath) {
        File file = File.createAsFacade((Map)((Map)element));
        GridFSBucket bucket = MongoDBFileHelper.getGridFSBucket(client, config);
        String fileName = MongoDBFileHelper.constructFileName(submodelId, file, idShortPath);
        MongoDBFileHelper.deleteAllDuplicateFiles(bucket, fileName, MongoDBFileHelper.legacyFileName(submodelId, file, idShortPath));
        bucket.uploadFromStream(fileName, newValue);
        return fileName;
    }

    public static void deleteAllFilesFromGridFsIfIsFileSubmodelElement(MongoClient client, BaSyxMongoDBConfiguration config, Submodel sm, String idShort) {
        Map submodelElement = (Map)sm.getSubmodelElement(idShort);
        if (!File.isFile((Map)submodelElement)) {
            return;
        }
        File file = File.createAsFacade((Map)submodelElement);
        GridFSBucket bucket = MongoDBFileHelper.getGridFSBucket(client, config);
        MongoDBFileHelper.deleteAllDuplicateFiles(bucket, MongoDBFileHelper.constructFileName(sm.getIdentification().getId(), file, idShort), MongoDBFileHelper.legacyFileName(sm.getIdentification().getId(), file, idShort));
    }

    protected static boolean fileExists(GridFSBucket bucket, String fileName) {
        return bucket.find(Filters.eq((String)"filename", (Object)fileName)).first() != null;
    }

    public static GridFSBucket getGridFSBucket(MongoClient client, BaSyxMongoDBConfiguration config) {
        MongoDatabase database = client.getDatabase(config.getDatabase());
        return GridFSBuckets.create((MongoDatabase)database, (String)config.getFileCollection());
    }

    private static void deleteAllDuplicateFiles(GridFSBucket bucket, String ... fileNames) {
        bucket.find(Filters.or((Iterable)Arrays.stream(fileNames).map(fileName -> Filters.eq((String)"filename", (Object)fileName)).collect(Collectors.toList()))).forEach(gridFile -> bucket.delete(gridFile.getObjectId()));
    }

    public static String constructFileName(String submodelId, File file, String idShortPath) {
        Object fileName = submodelId + "-" + idShortPath.replaceAll("/", "-") + MongoDBFileHelper.getFileExtension(file);
        fileName = ((String)fileName).replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        return String.format("#%s#", Objects.hashCode(submodelId)).concat((String)fileName);
    }

    public static String legacyFileName(String submodelId, File file, String idShortPath) {
        return submodelId + "-" + idShortPath.replaceAll("/", "-") + MongoDBFileHelper.getFileExtension(file);
    }

    private static String getFileExtension(File file) {
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        try {
            MimeType mimeType = allTypes.forName(file.getMimeType());
            return mimeType.getExtension();
        }
        catch (MimeTypeException e) {
            e.printStackTrace();
            return "";
        }
    }
}

