/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPI;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPIFactory;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBAASAPI
implements IAASAPI {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_CONFIG_PATH = "mongodb.properties";
    protected String collectionName;
    private MongoDBBaSyxStorageAPI<AssetAdministrationShell> storageApi;
    private String shellIdentificationId;

    public MongoDBAASAPI(BaSyxMongoDBConfiguration config, String shellIdentificationId, MongoClient client) {
        this((MongoDBBaSyxStorageAPI<AssetAdministrationShell>)MongoDBBaSyxStorageAPIFactory.create((String)config.getAASCollection(), AssetAdministrationShell.class, (BaSyxMongoDBConfiguration)config, (MongoClient)client), shellIdentificationId);
    }

    public MongoDBAASAPI(MongoDBBaSyxStorageAPI<AssetAdministrationShell> mongoDBStorageAPI, String shellIdentificationId) {
        this.storageApi = mongoDBStorageAPI;
        this.shellIdentificationId = shellIdentificationId;
    }

    public MongoDBAASAPI(String resourceConfigPath, String shellIdentificationId, MongoClient client) {
        this((MongoDBBaSyxStorageAPI<AssetAdministrationShell>)MongoDBBaSyxStorageAPIFactory.create((String)MongoDBAASAPI.configFromResource(resourceConfigPath).getSubmodelCollection(), AssetAdministrationShell.class, (BaSyxMongoDBConfiguration)MongoDBAASAPI.configFromResource(resourceConfigPath), (MongoClient)client), shellIdentificationId);
    }

    public MongoDBAASAPI(String shellIdentificationId, MongoClient client) {
        this(DEFAULT_CONFIG_PATH, shellIdentificationId, client);
    }

    @Deprecated
    public MongoDBAASAPI(BaSyxMongoDBConfiguration config, String shellIdentificationId) {
        this((MongoDBBaSyxStorageAPI<AssetAdministrationShell>)MongoDBBaSyxStorageAPIFactory.create((String)config.getAASCollection(), AssetAdministrationShell.class, (BaSyxMongoDBConfiguration)config), shellIdentificationId);
    }

    @Deprecated
    public MongoDBAASAPI(String resourceConfigPath, String shellIdentificationId) {
        this((MongoDBBaSyxStorageAPI<AssetAdministrationShell>)MongoDBBaSyxStorageAPIFactory.create((String)MongoDBAASAPI.configFromResource(resourceConfigPath).getSubmodelCollection(), AssetAdministrationShell.class, (BaSyxMongoDBConfiguration)MongoDBAASAPI.configFromResource(resourceConfigPath)), shellIdentificationId);
    }

    @Deprecated
    public MongoDBAASAPI(String shellIdentificationId) {
        this(DEFAULT_CONFIG_PATH, shellIdentificationId);
    }

    private static BaSyxMongoDBConfiguration configFromResource(String resourceConfigPath) {
        BaSyxMongoDBConfiguration config = new BaSyxMongoDBConfiguration();
        config.loadFromResource(resourceConfigPath);
        return config;
    }

    public void setConfiguration(BaSyxMongoDBConfiguration config) {
        this.collectionName = config.getAASCollection();
        MongoDBBaSyxStorageAPIFactory storageApiFactory = new MongoDBBaSyxStorageAPIFactory(config, AssetAdministrationShell.class, this.collectionName);
        this.storageApi = storageApiFactory.create();
    }

    public void setConfiguration(BaSyxMongoDBConfiguration config, MongoClient client) {
        this.collectionName = config.getAASCollection();
        MongoDBBaSyxStorageAPIFactory storageApiFactory = new MongoDBBaSyxStorageAPIFactory(config, AssetAdministrationShell.class, this.collectionName, client);
        this.storageApi = storageApiFactory.create();
    }

    public void setAASId(String shellIdentificationId) {
        this.shellIdentificationId = shellIdentificationId;
    }

    public void setAAS(AssetAdministrationShell shell) {
        String id = shell.getIdentification().getId();
        this.setAASId(id);
        this.storageApi.createOrUpdate((Object)shell);
    }

    public IAssetAdministrationShell getAAS() {
        return (IAssetAdministrationShell)this.storageApi.retrieve(this.shellIdentificationId);
    }

    public void addSubmodel(IReference submodelReference) {
        AssetAdministrationShell shell = (AssetAdministrationShell)this.getAAS();
        shell.addSubmodelReference(submodelReference);
        this.storageApi.update((Object)shell, this.shellIdentificationId);
    }

    public void removeSubmodel(String submodelIdShort) {
        AssetAdministrationShell shell = (AssetAdministrationShell)this.getAAS();
        Collection submodelReferences = shell.getSubmodelReferences();
        Optional<IReference> toBeRemoved = submodelReferences.stream().filter(submodelReference -> this.getLastSubmodelReferenceKey((IReference)submodelReference).getValue().equals(submodelIdShort)).findFirst();
        if (!toBeRemoved.isPresent() || toBeRemoved.isEmpty()) {
            this.logger.warn("Submodel reference could not be removed. Shell with identification id '{}' does not contain submodel with idShort '{}'.", (Object)shell.getIdentification().getId(), (Object)submodelIdShort);
            return;
        }
        submodelReferences.remove(toBeRemoved.get());
        shell.setSubmodelReferences(submodelReferences);
        this.storageApi.update((Object)shell, submodelIdShort);
    }

    private IKey getLastSubmodelReferenceKey(IReference submodelReference) {
        return (IKey)submodelReference.getKeys().get(this.getLastSubmodelReferenceReferenceIndex(submodelReference));
    }

    private int getLastSubmodelReferenceReferenceIndex(IReference submodelReference) {
        return submodelReference.getKeys().size() - 1;
    }
}

