/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mqtt;

import org.eclipse.basyx.aas.aggregator.api.IAASAggregatorFactory;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.extensions.aas.aggregator.mqtt.MqttV2AASAggregatorTopicFactory;
import org.eclipse.basyx.extensions.aas.aggregator.mqtt.MqttV2DecoratingAASAggregatorFactory;
import org.eclipse.basyx.extensions.shared.encoding.Base64URLEncoder;
import org.eclipse.basyx.extensions.shared.encoding.IEncoder;
import org.eclipse.basyx.extensions.submodel.aggregator.mqtt.MqttV2DecoratingSubmodelAggregatorFactory;
import org.eclipse.basyx.extensions.submodel.aggregator.mqtt.MqttV2SubmodelAggregatorTopicFactory;
import org.eclipse.basyx.extensions.submodel.mqtt.MqttV2DecoratingSubmodelAPIFactory;
import org.eclipse.basyx.extensions.submodel.mqtt.MqttV2SubmodelAPITopicFactory;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.paho.client.mqttv3.MqttClient;

public class MqttV2AASServerDecorator
implements IAASServerDecorator {
    private MqttClient client;
    private String aasRepoId;
    private IEncoder idEncoder;

    public MqttV2AASServerDecorator(MqttClient client, String aasRepoId, IEncoder idEncoder) {
        this.client = client;
        this.aasRepoId = aasRepoId;
        this.idEncoder = idEncoder;
    }

    @Override
    public ISubmodelAPIFactory decorateSubmodelAPIFactory(ISubmodelAPIFactory submodelAPIFactory) {
        return new MqttV2DecoratingSubmodelAPIFactory(submodelAPIFactory, this.client, this.aasRepoId, new MqttV2SubmodelAPITopicFactory(this.idEncoder));
    }

    @Override
    public ISubmodelAggregatorFactory decorateSubmodelAggregatorFactory(ISubmodelAggregatorFactory submodelAggregatorFactory) {
        return new MqttV2DecoratingSubmodelAggregatorFactory(submodelAggregatorFactory, this.client, this.aasRepoId, new MqttV2SubmodelAggregatorTopicFactory(this.idEncoder));
    }

    @Override
    public IAASAPIFactory decorateAASAPIFactory(IAASAPIFactory aasAPIFactory) {
        return aasAPIFactory;
    }

    @Override
    public IAASAggregatorFactory decorateAASAggregatorFactory(IAASAggregatorFactory aasAggregatorFactory) {
        return new MqttV2DecoratingAASAggregatorFactory(aasAggregatorFactory, this.client, this.aasRepoId, new MqttV2AASAggregatorTopicFactory((IEncoder)new Base64URLEncoder()));
    }
}

