/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.mongodb;

import java.util.List;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.memory.IRegistryHandler;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPI;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPIFactory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDBRegistryHandler
implements IRegistryHandler {
    private static final String DEFAULT_CONFIG_PATH = "mongodb.properties";
    private MongoDBBaSyxStorageAPI<AASDescriptor> storageApi;
    private static final String SHELL_IDENTIFICATION_ID = "identification.id";
    private static final String ASSET_IDENTIFICATION_ID = "asset.identification.id";

    public MongoDBRegistryHandler(BaSyxMongoDBConfiguration config) {
        this.initStorageApi(config);
    }

    public MongoDBRegistryHandler(String resourceConfigPath) {
        this(MongoDBRegistryHandler.configFromResource(resourceConfigPath));
    }

    private static BaSyxMongoDBConfiguration configFromResource(String resourceConfigPath) {
        BaSyxMongoDBConfiguration config = new BaSyxMongoDBConfiguration();
        config.loadFromResource(resourceConfigPath);
        return config;
    }

    public MongoDBRegistryHandler() {
        this(DEFAULT_CONFIG_PATH);
    }

    public void setConfiguration(BaSyxMongoDBConfiguration config) {
        this.initStorageApi(config);
    }

    private void initStorageApi(BaSyxMongoDBConfiguration config) {
        String collectionName = config.getRegistryCollection();
        MongoDBBaSyxStorageAPIFactory storageApiFactory = new MongoDBBaSyxStorageAPIFactory(config, AASDescriptor.class, collectionName);
        this.storageApi = storageApiFactory.create();
    }

    public boolean contains(IIdentifier identifier) {
        String identificationId = identifier.getId();
        Criteria hasId = new Criteria();
        hasId.orOperator(new Criteria[]{Criteria.where((String)SHELL_IDENTIFICATION_ID).is((Object)identificationId), Criteria.where((String)ASSET_IDENTIFICATION_ID).is((Object)identificationId)});
        return this.getStorageConnection().exists(Query.query((CriteriaDefinition)hasId), this.storageApi.getCollectionName());
    }

    private MongoOperations getStorageConnection() {
        return (MongoOperations)this.storageApi.getStorageConnection();
    }

    public void remove(IIdentifier identifier) {
        String indentificationId = identifier.getId();
        Criteria hasId = new Criteria();
        hasId.orOperator(new Criteria[]{Criteria.where((String)SHELL_IDENTIFICATION_ID).is((Object)indentificationId), Criteria.where((String)ASSET_IDENTIFICATION_ID).is((Object)indentificationId)});
        this.getStorageConnection().remove(Query.query((CriteriaDefinition)hasId), this.storageApi.getCollectionName());
    }

    public void insert(AASDescriptor descriptor) {
        this.update(descriptor);
    }

    public void update(AASDescriptor descriptor) {
        this.storageApi.createOrUpdate((Object)descriptor);
    }

    public AASDescriptor get(IIdentifier identifier) {
        String indentificationId = identifier.getId();
        Criteria hasId = new Criteria();
        hasId.orOperator(new Criteria[]{Criteria.where((String)SHELL_IDENTIFICATION_ID).is((Object)indentificationId), Criteria.where((String)ASSET_IDENTIFICATION_ID).is((Object)indentificationId)});
        AASDescriptor result = (AASDescriptor)this.getStorageConnection().findOne(Query.query((CriteriaDefinition)hasId), AASDescriptor.class, this.storageApi.getCollectionName());
        return (AASDescriptor)this.storageApi.handleMongoDbIdAttribute((Object)result);
    }

    public List<AASDescriptor> getAll() {
        return (List)this.storageApi.retrieveAll();
    }
}

