/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.basyx.vab.protocol.basyx.CoderTools;

public class BaSyxVABTCPPayloadCodec
implements ProtocolServerBuilder.PayloadCodec {
    private Charset charset = Charset.forName("UTF-8");

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Schema intendedSchema() {
        return Schema.TCP;
    }

    public byte[] encode(String info, byte[] payload) {
        int resultFrameSize = 4 + (info == null ? 0 : info.length()) + payload.length;
        byte[] frameLength = new byte[4];
        byte[] infoLength = new byte[4];
        CoderTools.setInt32((byte[])frameLength, (int)0, (int)resultFrameSize);
        CoderTools.setInt32((byte[])infoLength, (int)0, (int)(null == info ? -1 : info.length()));
        ByteBuffer buffer = ByteBuffer.allocate(resultFrameSize + 4);
        buffer.put(frameLength);
        buffer.put(infoLength);
        if (info != null) {
            buffer.put(info.getBytes(this.charset));
        }
        buffer.put(payload);
        ((Buffer)buffer).flip();
        return buffer.array();
    }

    public int getDataBytesLength() {
        return 4;
    }

    public int decodeDataLength(byte[] data) {
        return CoderTools.getInt32((byte[])data, (int)0);
    }

    public void decode(byte[] data, ProtocolServerBuilder.PayloadConsumer consumer) {
        String info;
        int infoLength = CoderTools.getInt32((byte[])data, (int)0);
        if (infoLength < 0) {
            info = null;
            infoLength = 0;
        } else {
            info = new String(data, 4, infoLength, this.charset);
        }
        byte[] payload = new byte[data.length - 4 - infoLength];
        System.arraycopy(data, 4 + infoLength, payload, 0, payload.length);
        consumer.decoded(info, payload);
    }
}

