/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.ExtensionBasedFileFormat;
import de.iip_ecosphere.platform.support.FileFormat;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.basyx.aas.factory.json.JSONToMetamodelConverter;
import org.eclipse.basyx.aas.factory.json.MetamodelToJSONConverter;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;

public class JsonPersistenceRecipe
extends AbstractPersistenceRecipe {
    private static final FileFormat JSON = new ExtensionBasedFileFormat("json", "AAS JSON", "AAS in JSON");

    JsonPersistenceRecipe() {
        super(JSON);
    }

    public void writeTo(List<Aas> aas, File thumbnail, List<PersistenceRecipe.FileResource> resources, File file) throws IOException {
        ArrayList<AssetAdministrationShell> basyxAas = new ArrayList<AssetAdministrationShell>();
        ArrayList<org.eclipse.basyx.submodel.metamodel.map.Submodel> basyxSubmodels = new ArrayList<org.eclipse.basyx.submodel.metamodel.map.Submodel>();
        ArrayList assetList = new ArrayList();
        ArrayList conceptDescriptionList = new ArrayList();
        for (Aas a : aas) {
            if (a instanceof BaSyxAas) {
                basyxAas.add(JsonPersistenceRecipe.ensureLocal(((BaSyxAas)a).getAas()));
                for (Submodel s : a.submodels()) {
                    basyxSubmodels.add(JsonPersistenceRecipe.ensureLocal(((BaSyxSubmodel)s).getSubmodel()));
                }
                JsonPersistenceRecipe.addAsset(a, assetList, Asset.class);
                continue;
            }
            throw new IllegalArgumentException("Can only write directly created AAS: " + a.getIdShort());
        }
        String json = MetamodelToJSONConverter.convertToJSON(basyxAas, assetList, conceptDescriptionList, basyxSubmodels);
        FileUtils.writeStringToFile((File)file, (String)json, (Charset)Charset.defaultCharset());
    }

    public List<Aas> readFrom(File file) throws IOException {
        ArrayList<Aas> result = new ArrayList<Aas>();
        String json = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        JSONToMetamodelConverter conv = new JSONToMetamodelConverter(json);
        this.transform(conv.parseAAS(), conv.parseSubmodels(), conv.parseAssets(), result);
        return result;
    }
}

