/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx.basyx;

import de.iip_ecosphere.platform.support.aas.basyx.basyx.VABBaSyxTCPInterface;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.service.api.BaSyxService;

public class BaSyxTCPServer<T extends IModelProvider>
implements Runnable,
BaSyxService {
    private static Logger logger = LoggerFactory.getLogger(BaSyxTCPServer.class);
    protected ServerSocketChannel serverSockChannel = null;
    protected T providerBackend = null;
    protected boolean exit = false;
    protected Thread thread = null;
    protected String name = null;

    public BaSyxTCPServer(T modelProviderBackend, int serverPort) {
        this.providerBackend = modelProviderBackend;
        try {
            InetAddress hostIPAddress = InetAddress.getByName("0.0.0.0");
            this.serverSockChannel = ServerSocketChannel.open();
            this.serverSockChannel.configureBlocking(true);
            this.serverSockChannel.socket().bind(new InetSocketAddress(hostIPAddress, serverPort));
        }
        catch (IOException e) {
            logger.error("Exception in BaSyxTCPServer", (Throwable)e);
        }
    }

    public BaSyxTCPServer(T modelProviderBackend) {
        this(modelProviderBackend, 6998);
    }

    @Override
    public void run() {
        while (!this.exit) {
            this.acceptIncomingConnection();
        }
    }

    public void acceptIncomingConnection() {
        try {
            SocketChannel communicationSocket = null;
            try {
                communicationSocket = this.serverSockChannel.accept();
            }
            catch (SocketException e) {
                logger.error("Exception in acceptIncomingConnection", (Throwable)e);
                this.exit = true;
                return;
            }
            VABBaSyxTCPInterface<T> tcpProvider = new VABBaSyxTCPInterface<T>(this.providerBackend, communicationSocket);
            tcpProvider.start();
        }
        catch (IOException e) {
            if (!this.exit) {
                logger.error("Exception in acceptIncomingConnection", (Throwable)e);
            }
            return;
        }
    }

    protected void shutdown() {
        this.exit = true;
        try {
            this.serverSockChannel.close();
        }
        catch (IOException e) {
            logger.error("Exception in shutdown", (Throwable)e);
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.shutdown();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            logger.error("Exception in stop", (Throwable)e);
        }
    }

    public BaSyxService setName(String newName) {
        this.name = newName;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void waitFor() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            logger.error("Exception in waitFor", (Throwable)e);
        }
    }

    public boolean hasEnded() {
        return !this.serverSockChannel.isOpen();
    }
}

