/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.tools.lib;

import java.io.File;
import java.util.StringTokenizer;

public class PythonUtils {
    public static final File DEFAULT_PYTHON_EXECUTABLE;
    private static File pythonExecutable;

    public static boolean isOsWindows() {
        return PythonUtils.getSystemProperty("os.name", "").startsWith("Windows");
    }

    public static String getOsPath() {
        String tmp = System.getenv(PythonUtils.isOsWindows() ? "PATH" : "path");
        return null == tmp ? "" : tmp;
    }

    public static String getSystemProperty(String property, String dflt) {
        String result;
        try {
            result = System.getProperty(property, dflt);
        }
        catch (SecurityException ex) {
            result = dflt;
        }
        return result;
    }

    public static void setPythonExecutable(File exec) {
        pythonExecutable = exec;
    }

    public static File getPythonExecutable() {
        return PythonUtils.getPythonExecutable(null);
    }

    public static File getPythonExecutable(String pythonBinary) {
        File tmpPath;
        File result = pythonExecutable;
        String path = System.getenv("IIP_PYTHON");
        if (null == path) {
            path = pythonBinary;
        }
        if (null == path) {
            path = "/var/lib/jenkins/python/active/bin/python3";
        }
        if ((tmpPath = new File(path)).exists()) {
            result = tmpPath;
        } else {
            path = PythonUtils.getOsPath();
            if (null != path) {
                String suffix = PythonUtils.isOsWindows() ? ".exe" : "";
                StringTokenizer pathEntries = new StringTokenizer(path, File.pathSeparator);
                while (pathEntries.hasMoreTokens()) {
                    String pe = pathEntries.nextToken();
                    tmpPath = new File(pe, "python3" + suffix);
                    if (tmpPath.exists()) {
                        result = tmpPath;
                        break;
                    }
                    tmpPath = new File(pe, "python" + suffix);
                    if (!tmpPath.exists()) continue;
                    result = tmpPath;
                    break;
                }
            }
            if (null == result && (tmpPath = new File("/usr/bin/python3")).exists()) {
                result = tmpPath;
            }
        }
        if (null == result) {
            result = new File("python");
        }
        return result;
    }

    public static String getPythonArgs(String pythonArgs) {
        String result = pythonArgs;
        if (null == result || result.isEmpty()) {
            result = System.getenv("IIP_PYTHONARGS");
        }
        return result;
    }

    public static final String[] insertArgs(String[] cmd, int pos, String args) {
        String[] result = cmd;
        if (args == null) {
            args = "";
        }
        if ((args = args.trim()).length() > 0) {
            String[] tmpArgs = args.split(" ");
            if (pos >= 0 || pos <= cmd.length) {
                result = new String[cmd.length + tmpArgs.length];
                System.arraycopy(cmd, 0, result, 0, pos);
                System.arraycopy(tmpArgs, 0, result, pos, tmpArgs.length);
                System.arraycopy(cmd, pos, result, pos + tmpArgs.length, cmd.length - pos);
            }
        }
        return result;
    }

    static {
        pythonExecutable = DEFAULT_PYTHON_EXECUTABLE = null;
    }
}

