/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.AasEnv;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.parts.ConceptDescription;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;

public class JSONToMetamodelConverter {
    private AasEnv aasEnv;

    public JSONToMetamodelConverter(String jsonContent) {
        Map<String, Object> root = this.createRoot(jsonContent);
        List<IAsset> assets = this.createAssets(root);
        List<IAssetAdministrationShell> shells = this.createShells(root, assets);
        List<IConceptDescription> conceptDescriptions = this.createConceptDescriptions(root);
        List<ISubmodel> submodels = this.createSubmodels(root);
        this.aasEnv = new AasEnv(shells, assets, conceptDescriptions, submodels);
    }

    private List<ISubmodel> createSubmodels(Map<String, Object> root) {
        return ((List)root.get("submodels")).stream().map(smMap -> Submodel.createAsFacade((Map)smMap)).collect(Collectors.toList());
    }

    private List<IConceptDescription> createConceptDescriptions(Map<String, Object> root) {
        return ((List)root.get("conceptDescriptions")).stream().map(cdMap -> ConceptDescription.createAsFacade((Map)cdMap)).collect(Collectors.toList());
    }

    private List<IAssetAdministrationShell> createShells(Map<String, Object> root, List<IAsset> assets) {
        return ((List)root.get("assetAdministrationShells")).stream().map(aasObject -> this.handleJSONAssetReference(aasObject, assets)).collect(Collectors.toList());
    }

    private List<IAsset> createAssets(Map<String, Object> root) {
        return ((List)root.get("assets")).stream().map(aMap -> Asset.createAsFacade((Map)aMap)).collect(Collectors.toList());
    }

    private Map<String, Object> createRoot(String jsonContent) {
        return (Map)new GSONTools(new DefaultTypeFactory()).deserialize(jsonContent);
    }

    public AasEnv parseAasEnv() {
        return this.aasEnv;
    }

    public List<AssetAdministrationShell> parseAAS() {
        return new ArrayList<AssetAdministrationShell>((List)this.aasEnv.getAssetAdministrationShells());
    }

    private AssetAdministrationShell handleJSONAssetReference(Object aasObject, List<Asset> assets) {
        Map aasMap = (Map)aasObject;
        Map assetRefMap = (Map)aasMap.get("asset");
        if (this.isAssetReference(assetRefMap)) {
            return this.handleReference(aasObject, aasMap, assetRefMap, assets);
        }
        return AssetAdministrationShell.createAsFacade((Map)aasObject);
    }

    private AssetAdministrationShell handleReference(Object aasObject, Map<String, Object> aasMap, Map<String, Object> assetRefMap, List<Asset> assets) {
        aasMap.put("assetRef", assetRefMap);
        Reference assetRef = Reference.createAsFacade((Map)aasMap.get("assetRef"));
        IKey lastKey = assetRef.getKeys().get(assetRef.getKeys().size() - 1);
        String idValue = lastKey.getValue();
        for (Asset asset : assets) {
            if (!asset.getIdentification().getId().equals(idValue)) continue;
            aasMap.put("asset", asset);
            break;
        }
        return AssetAdministrationShell.createAsFacade((Map)aasObject);
    }

    private boolean isAssetReference(Map<String, Object> assetRefMap) {
        return assetRefMap.get("keys") != null && assetRefMap.get("kind") == null;
    }

    public List<Submodel> parseSubmodels() {
        return new ArrayList<Submodel>((List)this.aasEnv.getSubmodels());
    }

    public List<Asset> parseAssets() {
        return new ArrayList<Asset>((List)this.aasEnv.getAssets());
    }

    public List<ConceptDescription> parseConceptDescriptions() {
        return new ArrayList<ConceptDescription>((List)this.aasEnv.getConceptDescriptions());
    }
}

