/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.IConceptDictionary;
import org.eclipse.basyx.aas.metamodel.api.parts.IView;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.api.security.ISecurity;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.aas.metamodel.map.parts.ConceptDictionary;
import org.eclipse.basyx.aas.metamodel.map.parts.View;
import org.eclipse.basyx.aas.metamodel.map.security.Security;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IEmbeddedDataSpecification;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IAdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.AdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.reference.ReferenceHelper;
import org.eclipse.basyx.vab.exception.FeatureNotImplementedException;
import org.eclipse.basyx.vab.model.VABModelMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetAdministrationShell
extends VABModelMap<Object>
implements IAssetAdministrationShell {
    private static Logger logger = LoggerFactory.getLogger(AssetAdministrationShell.class);
    public static final String SECURITY = "security";
    public static final String DERIVEDFROM = "derivedFrom";
    public static final String ASSET = "asset";
    public static final String ASSETREF = "assetRef";
    public static final String SUBMODELS = "submodels";
    public static final String VIEWS = "views";
    public static final String CONCEPTDICTIONARY = "conceptDictionary";
    public static final String TYPE = "type";
    public static final String ADDRESS = "address";
    public static final String MODELTYPE = "AssetAdministrationShell";

    public AssetAdministrationShell() {
        this(null, null, new Asset(), new HashSet<Submodel>(), new HashSet<IConceptDictionary>(), new HashSet<IView>());
    }

    public AssetAdministrationShell(String idShort, IIdentifier identification, Asset asset) {
        this(null, null, asset, new HashSet<Submodel>(), new HashSet<IConceptDictionary>(), new HashSet<IView>());
        this.setIdentification(identification);
        this.setIdShort(idShort);
    }

    public AssetAdministrationShell(Reference derivedFrom, Security security, Asset asset, Collection<Submodel> submodels, Collection<IConceptDictionary> dictionaries, Collection<IView> views) {
        this.putAll(new ModelType(MODELTYPE));
        this.putAll(new Identifiable());
        this.putAll(new HasDataSpecification());
        this.setSubmodelReferences(new HashSet<IReference>());
        this.setSecurity(security);
        this.setDerivedFrom(derivedFrom);
        this.setAsset(asset);
        this.setSubmodels(submodels);
        this.setViews(views);
        this.setConceptDictionary(dictionaries);
    }

    public static AssetAdministrationShell createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (!AssetAdministrationShell.isValid(map)) {
            throw new MetamodelConstructionException(AssetAdministrationShell.class, map);
        }
        if (!map.containsKey(SUBMODELS)) {
            map.put(SUBMODELS, new ArrayList());
        }
        AssetAdministrationShell ret = new AssetAdministrationShell();
        ret.setMap(map);
        return ret;
    }

    public static boolean isValid(Map<String, Object> map) {
        return Identifiable.isValid(map) && map.containsKey(ASSET) && Asset.isValid((Map)map.get(ASSET));
    }

    @Override
    public IAdministrativeInformation getAdministration() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getAdministration();
    }

    @Override
    public IIdentifier getIdentification() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getIdentification();
    }

    public void setAdministration(AdministrativeInformation information) {
        Identifiable.createAsFacade(this, this.getKeyElement()).setAdministration(information);
    }

    public void setIdentification(IIdentifier id) {
        this.setIdentification(id.getIdType(), id.getId());
    }

    public void setIdentification(IdentifierType idType, String id) {
        Identifiable.createAsFacadeNonStrict(this, this.getKeyElement()).setIdentification(idType, id);
    }

    @Override
    public Collection<IReference> getDataSpecificationReferences() {
        return HasDataSpecification.createAsFacade(this).getDataSpecificationReferences();
    }

    public void setDataSpecificationReferences(Collection<IReference> ref) {
        HasDataSpecification.createAsFacade(this).setDataSpecificationReferences(ref);
    }

    @Override
    public Collection<IEmbeddedDataSpecification> getEmbeddedDataSpecifications() {
        return HasDataSpecification.createAsFacade(this).getEmbeddedDataSpecifications();
    }

    public void setEmbeddedDataSpecifications(Collection<IEmbeddedDataSpecification> embeddedDataSpecifications) {
        HasDataSpecification.createAsFacade(this).setEmbeddedDataSpecifications(embeddedDataSpecifications);
    }

    public void setIdShort(String id) {
        Referable.createAsFacadeNonStrict(this, this.getKeyElement()).setIdShort(id);
    }

    public void setSecurity(ISecurity security) {
        this.put(SECURITY, security);
    }

    @Override
    public ISecurity getSecurity() {
        return Security.createAsFacade((Map)this.get(SECURITY));
    }

    public void setDerivedFrom(IReference derivedFrom) {
        this.put(DERIVEDFROM, derivedFrom);
    }

    @Override
    public IReference getDerivedFrom() {
        return Reference.createAsFacade((Map)this.get(DERIVEDFROM));
    }

    public void setAsset(Asset asset) {
        this.put(ASSET, asset);
    }

    @Override
    public IAsset getAsset() {
        return Asset.createAsFacade((Map)this.get(ASSET));
    }

    @Override
    public IReference getAssetReference() {
        return Reference.createAsFacade((Map)this.get(ASSETREF));
    }

    public void setAssetReference(Reference ref) {
        this.put(ASSETREF, ref);
    }

    public void setSubmodels(Collection<Submodel> submodels) {
        this.setSubmodelParent(submodels);
        ((Collection)this.get(SUBMODELS)).clear();
        submodels.stream().forEach(this::addSubmodelReferences);
    }

    public void setViews(Collection<IView> views) {
        this.put(VIEWS, views);
    }

    @Override
    public Collection<IView> getViews() {
        Collection coll = (Collection)this.get(VIEWS);
        return coll.stream().map(View::createAsFacade).collect(Collectors.toSet());
    }

    public void setConceptDictionary(Collection<IConceptDictionary> dictionaries) {
        this.put(CONCEPTDICTIONARY, dictionaries);
    }

    @Override
    public Collection<IConceptDictionary> getConceptDictionary() {
        Collection coll = (Collection)this.get(CONCEPTDICTIONARY);
        return coll.stream().map(ConceptDictionary::createAsFacade).collect(Collectors.toSet());
    }

    @Override
    public Map<String, ISubmodel> getSubmodels() {
        throw new RuntimeException("getSubmodels on local copy is not supported");
    }

    @Override
    public String getIdShort() {
        return Referable.createAsFacade(this, this.getKeyElement()).getIdShort();
    }

    @Override
    public String getCategory() {
        return Referable.createAsFacade(this, this.getKeyElement()).getCategory();
    }

    @Override
    public LangStrings getDescription() {
        return Referable.createAsFacade(this, this.getKeyElement()).getDescription();
    }

    @Override
    public IReference getParent() {
        return Referable.createAsFacade(this, this.getKeyElement()).getParent();
    }

    public void setCategory(String category) {
        Referable.createAsFacade(this, this.getKeyElement()).setCategory(category);
    }

    public void setDescription(LangStrings description) {
        Referable.createAsFacade(this, this.getKeyElement()).setDescription(description);
    }

    public void setParent(IReference obj) {
        Referable.createAsFacade(this, this.getKeyElement()).setParent(obj);
    }

    @Override
    public void addSubmodel(Submodel submodel) {
        logger.trace("adding Submodel", (Object)submodel.getIdentification().getId());
        this.setSubmodelParent(Collections.singletonList(submodel));
        this.addSubmodelReferences(submodel);
    }

    @Override
    public void removeSubmodel(IIdentifier id) {
        throw new FeatureNotImplementedException();
    }

    public void addConceptDescription(IConceptDescription description) {
        Collection dictionaries = (Collection)this.get(CONCEPTDICTIONARY);
        if (dictionaries.isEmpty()) {
            dictionaries.add(new ConceptDictionary("defaultConceptDictionary"));
        }
        ConceptDictionary dictionary = (ConceptDictionary)dictionaries.iterator().next();
        dictionary.addConceptDescription(description);
    }

    @Override
    public Collection<IReference> getSubmodelReferences() {
        return ReferenceHelper.transform(this.get(SUBMODELS));
    }

    public void setSubmodelReferences(Collection<IReference> references) {
        this.put(SUBMODELS, references);
    }

    public void addSubmodelReference(IReference reference) {
        Collection smReferences = (Collection)this.get(SUBMODELS);
        smReferences.add(reference);
    }

    private void addSubmodelReferences(Submodel submodel) {
        this.addSubmodelReference(submodel.getReference());
    }

    private KeyElements getKeyElement() {
        return KeyElements.ASSETADMINISTRATIONSHELL;
    }

    private void setSubmodelParent(Collection<Submodel> submodels) {
        for (Submodel submodel : submodels) {
            submodel.setParent(this.getReference());
        }
    }

    @Override
    public IReference getReference() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getReference();
    }

    @Override
    public ISubmodel getSubmodel(IIdentifier id) {
        throw new RuntimeException("getSubmodel on local copy is not supported");
    }
}

