/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.registration.authorization;

import java.util.List;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.extensions.shared.authorization.SecurityContextAuthorizer;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.exception.provider.ProviderException;

public class AuthorizedAASRegistry
implements IAASRegistry {
    public static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-registry:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-registry:write";
    private final IAASRegistry registry;
    private final SecurityContextAuthorizer authorizer = new SecurityContextAuthorizer();

    public AuthorizedAASRegistry(IAASRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void register(AASDescriptor deviceAASDescriptor) throws ProviderException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.registry.register(deviceAASDescriptor);
    }

    @Override
    public void register(IIdentifier aas, SubmodelDescriptor smDescriptor) throws ProviderException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.registry.register(aas, smDescriptor);
    }

    @Override
    public void delete(IIdentifier aasId) throws ProviderException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.registry.delete(aasId);
    }

    @Override
    public void delete(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.registry.delete(aasId, smId);
    }

    @Override
    public AASDescriptor lookupAAS(IIdentifier aasId) throws ProviderException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.registry.lookupAAS(aasId);
    }

    @Override
    public List<AASDescriptor> lookupAll() throws ProviderException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.registry.lookupAll();
    }

    @Override
    public List<SubmodelDescriptor> lookupSubmodels(IIdentifier aasId) throws ProviderException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.registry.lookupSubmodels(aasId);
    }

    @Override
    public SubmodelDescriptor lookupSubmodel(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.registry.lookupSubmodel(aasId, smId);
    }
}

