/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.common;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import de.iip_ecosphere.platform.support.net.SslUtils;
import java.io.File;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;

public class Tools {
    public static <A, C> A createApi(SetupSpec.ComponentSetup setup, String uri, C client, HttpClientBuilderConsumer<C> builderConsumer, UriConsumer<C> uriConsumer, ApiProvider<A, C> apiProvider, Class<A> cls) {
        Endpoint endpoint = setup.getEndpoint();
        KeyStoreDescriptor keystore = setup.getKeyStore();
        KeyStoreDescriptor ksd = null;
        if (null != keystore && keystore.appliesToClient() && (null == uri || uri.startsWith(endpoint.toServerUri()))) {
            ksd = keystore;
        }
        Consumer<HttpRequest.Builder> interceptor = null;
        if (setup.getAuthentication() != null) {
            interceptor = b -> AuthenticationDescriptor.authenticate((n, v) -> b.header(n, v), (AuthenticationDescriptor)setup.getAuthentication());
        }
        try {
            builderConsumer.accept(Tools.createHttpClient(ksd), client, interceptor);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Tools.class).error("While creating {}, creating http client failed: {}", (Object)cls.getName(), (Object)e.getMessage());
        }
        String u = null == uri ? endpoint.toServerUri() : uri;
        uriConsumer.accept(u, client);
        return apiProvider.create(u, client);
    }

    public static HttpClient.Builder createHttpClient(KeyStoreDescriptor desc) throws IOException {
        SSLContext context = null;
        Boolean oldHNV = null;
        if (null != desc) {
            context = SslUtils.createTlsContext((File)desc.getPath(), (String)desc.getPassword(), (String)desc.getAlias());
            oldHNV = Tools.setJdkHostnameVerification(desc);
        }
        HttpClient.Builder result = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1);
        if (null != context) {
            result.sslContext(context);
        }
        if (null != oldHNV) {
            Tools.setJdkHostnameVerification(oldHNV);
        }
        return result;
    }

    public static boolean setJdkHostnameVerification(KeyStoreDescriptor desc) {
        return Tools.setJdkHostnameVerification(!desc.applyHostnameVerification());
    }

    public static boolean setJdkHostnameVerification(boolean disable) {
        String prop = "jdk.internal.httpclient.disableHostnameVerification";
        boolean old = Boolean.valueOf(System.getProperty("jdk.internal.httpclient.disableHostnameVerification", "false"));
        System.setProperty("jdk.internal.httpclient.disableHostnameVerification", String.valueOf(disable));
        return old;
    }

    public static interface HttpClientBuilderConsumer<C> {
        public void accept(HttpClient.Builder var1, C var2, Consumer<HttpRequest.Builder> var3);
    }

    public static interface UriConsumer<C> {
        public void accept(String var1, C var2);
    }

    public static interface ApiProvider<A, C> {
        public A create(String var1, C var2);
    }
}

