/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.common;

import java.io.IOException;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;

public class ExcludeBasyxTypeFilter
implements TypeFilter {
    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        ClassMetadata classMetadata = metadataReader.getClassMetadata();
        String fullyQualifiedName = classMetadata.getClassName();
        boolean exclude = fullyQualifiedName.startsWith("org.eclipse.digitaltwin.basyx.");
        exclude &= !fullyQualifiedName.startsWith("org.eclipse.digitaltwin.basyx.http.");
        exclude &= !fullyQualifiedName.startsWith("org.eclipse.digitaltwin.basyx.serialization");
        exclude &= !fullyQualifiedName.startsWith("org.eclipse.digitaltwin.basyx.deserialization");
        exclude &= !fullyQualifiedName.startsWith("org.eclipse.digitaltwin.basyx.aasrepository.client.");
        exclude &= !fullyQualifiedName.startsWith("org.eclipse.digitaltwin.basyx.submodelservice.");
        exclude &= !fullyQualifiedName.startsWith("org.eclipse.digitaltwin.aas4j");
        exclude &= !fullyQualifiedName.startsWith("org.eclipse.digitaltwin.basyx.submodelrepository.client");
        AnnotationMetadata metadata = metadataReader.getAnnotationMetadata();
        if (metadata.hasAnnotation(SpringBootApplication.class.getName())) {
            exclude = true;
        }
        return exclude;
    }
}

