/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import de.iip_ecosphere.platform.support.net.SslUtils;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SSLConnectorCustomizer
implements TomcatConnectorCustomizer {
    @Autowired(required=false)
    private KeyStoreDescriptor kstore;
    private final int port;

    public SSLConnectorCustomizer(@Value(value="${server.port}") int port) {
        this.port = port;
    }

    public void customize(Connector connector) {
        if (null != this.kstore) {
            try {
                KeyStore ks = SslUtils.openKeyStore((File)this.kstore.getPath(), (String)this.kstore.getPassword());
                TrustManagerFactory tmf = SslUtils.createTrustManagerFactory((KeyStore)ks);
                KeyManager[] kms = SslUtils.createKeyManagers((KeyStore)ks, (String)this.kstore.getPassword(), (String)this.kstore.getAlias());
                Runtime.Version ver = Runtime.version();
                String protocolName = ver.feature() >= 17 ? "TLSv1.3" : "TLSv1";
                JSSESSLContext sslContext = new JSSESSLContext(protocolName);
                sslContext.init(kms, tmf.getTrustManagers(), new SecureRandom());
                connector.setScheme("https");
                connector.setSecure(true);
                connector.setPort(this.port);
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)connector.getProtocolHandler();
                protocol.setSSLEnabled(true);
                SSLHostConfig sslHostConfig = new SSLHostConfig();
                SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
                certificate.setSslContext((org.apache.tomcat.util.net.SSLContext)sslContext);
                sslHostConfig.addCertificate(certificate);
                protocol.addSslHostConfig(sslHostConfig);
            }
            catch (IOException | KeyManagementException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot setup SSL on port {}, staying with http: {}", (Object)this.port, (Object)e.getMessage());
            }
        }
    }

    private static class JSSESSLContext
    implements org.apache.tomcat.util.net.SSLContext {
        private SSLContext context;
        private KeyManager[] kms;
        private TrustManager[] tms;

        private JSSESSLContext(String protocol) throws IOException {
            try {
                this.context = SSLContext.getInstance(protocol);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
        }

        public void init(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
            this.kms = kms;
            this.tms = tms;
            this.context.init(kms, tms, sr);
        }

        public void destroy() {
        }

        public SSLSessionContext getServerSessionContext() {
            return this.context.getServerSessionContext();
        }

        public SSLEngine createSSLEngine() {
            return this.context.createSSLEngine();
        }

        public SSLServerSocketFactory getServerSocketFactory() {
            return this.context.getServerSocketFactory();
        }

        public SSLParameters getSupportedSSLParameters() {
            return this.context.getSupportedSSLParameters();
        }

        public X509Certificate[] getCertificateChain(String alias) {
            X509Certificate[] result = null;
            if (this.kms != null) {
                for (int i = 0; i < this.kms.length && result == null; ++i) {
                    if (!(this.kms[i] instanceof X509KeyManager)) continue;
                    result = ((X509KeyManager)this.kms[i]).getCertificateChain(alias);
                }
            }
            return result;
        }

        public X509Certificate[] getAcceptedIssuers() {
            HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
            if (this.tms != null) {
                for (TrustManager tm : this.tms) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    X509Certificate[] accepted = ((X509TrustManager)tm).getAcceptedIssuers();
                    certs.addAll(Arrays.asList(accepted));
                }
            }
            return certs.toArray(new X509Certificate[0]);
        }
    }
}

