/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security;

import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security.SSLConnectorCustomizer;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AnonymousConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class ServerConfig {
    @Autowired(required=false)
    private AuthenticationDescriptor authDesc;

    @Bean
    public ServletWebServerFactory servletContainer(SSLConnectorCustomizer sslConnectorCustomizer) {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addConnectorCustomizers(new TomcatConnectorCustomizer[]{sslConnectorCustomizer});
        return tomcat;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity) throws Exception {
        httpSecurity.securityMatcher(new String[]{"/**"});
        if (null != this.authDesc) {
            httpSecurity.authorizeHttpRequests(req -> {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)req.requestMatchers(new String[]{"/error"})).permitAll();
                if (this.authDesc.requiresAnonymousAccess()) {
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)req.anyRequest()).permitAll();
                } else {
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)req.anyRequest()).authenticated();
                }
            });
            httpSecurity.httpBasic(Customizer.withDefaults());
            if (this.authDesc.requiresAnonymousAccess()) {
                AuthenticationDescriptor.DefaultRole role = AuthenticationDescriptor.DefaultRole.NONE;
                httpSecurity.anonymous(arg_0 -> ServerConfig.lambda$securityFilterChain$1((AuthenticationDescriptor.Role)role, arg_0));
            }
            httpSecurity.csrf(c -> c.disable());
            return (SecurityFilterChain)httpSecurity.build();
        }
        httpSecurity.authorizeHttpRequests(req -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)req.anyRequest()).permitAll()).httpBasic(Customizer.withDefaults()).csrf(c -> c.ignoringRequestMatchers(new RequestMatcher[]{r -> true}));
        return (SecurityFilterChain)httpSecurity.build();
    }

    @Bean
    public UserDetailsService userDetailsService() {
        List sUsers;
        ArrayList<UserDetails> users = new ArrayList<UserDetails>();
        if (null != this.authDesc && this.authDesc.getServerUsers() != null && null != (sUsers = this.authDesc.getServerUsers())) {
            block3: for (AuthenticationDescriptor.IdentityTokenWithRole t : sUsers) {
                switch (t.getType()) {
                    case USERNAME: {
                        String pwPrefix = "";
                        String tea = t.getTokenEncryptionAlgorithm();
                        if ("UTF-8".equalsIgnoreCase(tea)) {
                            pwPrefix = "{noop}";
                        } else if ("BCRYPT".equalsIgnoreCase(tea)) {
                            pwPrefix = "{bcrypt}";
                        } else if ("SHA256".equalsIgnoreCase(tea)) {
                            pwPrefix = "{sha256}";
                        }
                        users.add(User.withUsername((String)t.getUserName()).password(pwPrefix + t.getTokenDataAsString()).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority(t.getRole().name())}).build());
                        continue block3;
                    }
                }
                LoggerFactory.getLogger(this.getClass()).warn("Token type {} for user {} cannot be processed. Skipping.", (Object)t.getType(), (Object)t.getUserName());
            }
        }
        return new InMemoryUserDetailsManager(users);
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        return web -> web.debug(false);
    }

    private static /* synthetic */ void lambda$securityFilterChain$1(AuthenticationDescriptor.Role role, AnonymousConfigurer c) {
        c.key(role.name()).authorities(new String[]{role.name()}).principal((Object)role.name());
    }
}

