/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.submodelRegistry;

import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.submodelRegistry.SubmodelRegistryTypeFilter;
import org.eclipse.digitaltwin.basyx.submodelregistry.service.api.LocationBuilder;
import org.eclipse.digitaltwin.basyx.submodelregistry.service.configuration.RestConfiguration;
import org.eclipse.digitaltwin.basyx.submodelregistry.service.events.RegistryEventLogSink;
import org.eclipse.digitaltwin.basyx.submodelregistry.service.events.RegistryEventSink;
import org.eclipse.digitaltwin.basyx.submodelregistry.service.storage.SubmodelRegistryStorage;
import org.eclipse.digitaltwin.basyx.submodelregistry.service.storage.memory.InMemorySubmodelRegistryStorage;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Profile;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.stereotype.Component;

@SpringBootApplication
@Configuration
@ComponentScan(basePackages={"org.eclipse.digitaltwin.basyx", "de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security"}, excludeFilters={@ComponentScan.Filter(type=FilterType.CUSTOM, classes={SubmodelRegistryTypeFilter.class})})
@Component
public class SubmodelRegistrySpringApp {
    public static void main(String[] args) {
        SpringApplication.run(SubmodelRegistrySpringApp.class, (String[])args);
    }

    @Bean
    public SubmodelRegistryStorage submodelRegistryStorage() {
        return new InMemorySubmodelRegistryStorage();
    }

    @Bean
    public RegistryEventSink registryEventSink() {
        return new RegistryEventLogSink();
    }

    @Bean
    public MappingJackson2HttpMessageConverter submodelRegistryMappingJackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter();
    }

    @Bean
    public LocationBuilder locationBuilder() {
        RestConfiguration config = new RestConfiguration();
        return config.submodelRegistryLocationBuilder();
    }

    @Profile(value={"test"})
    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll()).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }
}

