/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx2.server.BaSyxAbstractAasServer;
import de.iip_ecosphere.platform.support.aas.basyx2.server.BaSyxLocalServer;
import de.iip_ecosphere.platform.support.function.IORunnable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BaSyxDeploymentRecipe
implements DeploymentRecipe {
    private SetupSpec setupSpec;

    BaSyxDeploymentRecipe(SetupSpec spec) {
        this.setupSpec = spec;
    }

    public DeploymentRecipe setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        return this;
    }

    public DeploymentRecipe setBearerTokenAuthenticationConfiguration(String issuerUri, String jwkSetUri, String requiredAud) throws IllegalArgumentException {
        return this;
    }

    public DeploymentRecipe.ImmediateDeploymentRecipe forRegistry() {
        return new BaSyxImmediateDeploymentRecipe();
    }

    public DeploymentRecipe.RegistryDeploymentRecipe forRegistry(Endpoint aasRegistry, Endpoint smRegistry) {
        BasicSetupSpec spec = new BasicSetupSpec(this.setupSpec);
        spec.setRegistryEndpoints(aasRegistry, smRegistry);
        return new BaSyxRegistryDeploymentRecipe(this.setupSpec);
    }

    static void deploy(SetupSpec spec, Aas aas) throws IOException {
        Registry registry = AasFactory.getInstance().obtainRegistry(spec);
        registry.createAas(aas, "");
        String ep = registry.getEndpoint(aas);
        registry.register(aas, null, "");
        for (Submodel sm : aas.submodels()) {
            registry.createSubmodel(aas, sm);
            ep = registry.getEndpoint(aas, sm);
            registry.register(aas, sm, ep);
        }
    }

    private class BaSyxImmediateDeploymentRecipe
    implements DeploymentRecipe.ImmediateDeploymentRecipe {
        private List<IORunnable> actions = new ArrayList<IORunnable>();

        private BaSyxImmediateDeploymentRecipe() {
        }

        public DeploymentRecipe.ImmediateDeploymentRecipe deploy(Aas aas) throws IOException {
            this.actions.add(() -> BaSyxDeploymentRecipe.deploy(BaSyxDeploymentRecipe.this.setupSpec, aas));
            return this;
        }

        public AasServer createServer(String ... options) {
            return new BaSyxLocalServer(BaSyxDeploymentRecipe.this.setupSpec, BaSyxAbstractAasServer.ServerType.COMBINED, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, options).addActionsAfterStart((List)this.actions);
        }
    }

    private class BaSyxRegistryDeploymentRecipe
    implements DeploymentRecipe.RegistryDeploymentRecipe {
        private SetupSpec spec;

        private BaSyxRegistryDeploymentRecipe(SetupSpec spec) {
            this.spec = spec;
        }

        public Registry obtainRegistry() throws IOException {
            return AasFactory.getInstance().obtainRegistry(this.spec, this.spec.getAasRegistryEndpoint().getSchema());
        }

        public DeploymentRecipe.RegistryDeploymentRecipe deploy(Aas aas) throws IOException {
            BaSyxDeploymentRecipe.deploy(this.spec, aas);
            return this;
        }

        public AasServer createServer(String ... options) {
            return new BaSyxLocalServer(this.spec, BaSyxAbstractAasServer.ServerType.COMBINED, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, options);
        }
    }
}

