/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.aasRegistry;

import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.aasRegistry.AasRegistryTypeFilter;
import org.eclipse.digitaltwin.basyx.aasregistry.service.events.RegistryEventLogSink;
import org.eclipse.digitaltwin.basyx.aasregistry.service.events.RegistryEventSink;
import org.eclipse.digitaltwin.basyx.aasregistry.service.storage.AasRegistryStorage;
import org.eclipse.digitaltwin.basyx.aasregistry.service.storage.memory.InMemoryAasRegistryStorage;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.stereotype.Component;

@SpringBootApplication
@Configuration
@ComponentScan(basePackages={"org.eclipse.digitaltwin.basyx", "de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security"}, excludeFilters={@ComponentScan.Filter(type=FilterType.CUSTOM, classes={AasRegistryTypeFilter.class})})
@Component
public class AasRegistrySpringApp {
    public static void main(String[] args) {
        SpringApplication.run(AasRegistrySpringApp.class, (String[])args);
    }

    @Bean
    public static AasRegistryStorage getAasRegistry() {
        return new InMemoryAasRegistryStorage();
    }

    @Bean
    public RegistryEventSink registryEventSink() {
        return new RegistryEventLogSink();
    }

    @Profile(value={"test"})
    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll()).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }
}

