/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.common;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public abstract class ClasspathResourceLoadingInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private Pattern classpathPattern;

    public ClasspathResourceLoadingInitializer(String cpPattern) {
        this.classpathPattern = Pattern.compile(cpPattern);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ClassLoader loader = this.getClass().getClassLoader();
        if (null != this.classpathPattern) {
            try {
                Enumeration<URL> e = loader.getResources("application.yml");
                while (e.hasMoreElements()) {
                    URL u = e.nextElement();
                    if (!this.classpathPattern.matcher(u.toString()).matches()) continue;
                    UrlResource resource = new UrlResource(u);
                    YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
                    factory.setResources(new Resource[]{resource});
                    factory.afterPropertiesSet();
                    applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)new PropertiesPropertySource("Initializer-injected Properties", factory.getObject()));
                    break;
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot load application.yaml: {}", (Object)e.getMessage());
            }
        }
    }
}

