/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.web.bind.annotation.RestController;

public abstract class ExcludeTypeFilter
implements TypeFilter {
    private List<String> excludePackages = new ArrayList<String>();

    protected ExcludeTypeFilter() {
        this.excludePackages.add("org.eclipse.digitaltwin.basyx.aasregistry.");
        this.excludePackages.add("org.eclipse.digitaltwin.basyx.aasrepository.");
        this.excludePackages.add("org.eclipse.digitaltwin.basyx.submodelregistry.");
        this.excludePackages.add("org.eclipse.digitaltwin.basyx.submodelrepository.");
        this.excludePackages.add("org.eclipse.digitaltwin.basyx.conceptdescriptionrepository.");
        this.excludePackages.add("org.eclipse.digitaltwin.basyx.aasdiscoveryservice.");
        this.excludePackages.add("org.eclipse.digitaltwin.basyx.aasenvironment.");
        this.excludePackages.add("org.eclipse.digitaltwin.basyx.authorization.");
    }

    protected void removeExclude(String pkg) {
        this.excludePackages.remove(pkg);
    }

    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        ClassMetadata classMetadata = metadataReader.getClassMetadata();
        String fullyQualifiedName = classMetadata.getClassName();
        AnnotationMetadata metadata = metadataReader.getAnnotationMetadata();
        boolean exclude = false;
        if (metadata.hasAnnotation(SpringBootApplication.class.getName()) || metadata.hasAnnotation(RestController.class.getName())) {
            exclude = true;
        }
        for (int e = 0; !exclude && e < this.excludePackages.size(); exclude |= fullyQualifiedName.startsWith(this.excludePackages.get(e)), ++e) {
        }
        return exclude;
    }
}

