/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security;

import com.google.common.base.Supplier;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security.AasInfoHandler;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security.SubmodelInfoCreator;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security.TargetInfoHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.digitaltwin.basyx.aasrepository.feature.authorization.AasTargetInformation;
import org.eclipse.digitaltwin.basyx.aasrepository.feature.authorization.rbac.AasTargetPermissionVerifier;
import org.eclipse.digitaltwin.basyx.authorization.rbac.Action;
import org.eclipse.digitaltwin.basyx.authorization.rbac.RbacPermissionResolver;
import org.eclipse.digitaltwin.basyx.authorization.rbac.RbacRule;
import org.eclipse.digitaltwin.basyx.authorization.rbac.RbacRuleKeyGenerator;
import org.eclipse.digitaltwin.basyx.authorization.rbac.RbacStorage;
import org.eclipse.digitaltwin.basyx.authorization.rbac.RoleProvider;
import org.eclipse.digitaltwin.basyx.authorization.rbac.SimpleRbacPermissionResolver;
import org.eclipse.digitaltwin.basyx.authorization.rbac.TargetInformation;
import org.eclipse.digitaltwin.basyx.authorization.rbac.TargetPermissionVerifier;
import org.eclipse.digitaltwin.basyx.authorization.rules.rbac.backend.inmemory.InMemoryAuthorizationRbacStorage;
import org.eclipse.digitaltwin.basyx.submodelrepository.feature.authorization.SubmodelTargetInformation;
import org.eclipse.digitaltwin.basyx.submodelrepository.feature.authorization.rbac.SubmodelTargetPermissionVerifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class RbacUtils {
    private static final Map<AuthenticationDescriptor.RbacAction, Action> ACTION_MAPPING = new HashMap<AuthenticationDescriptor.RbacAction, Action>();

    public static <T extends TargetInformation> RbacPermissionResolver<T> createPermissionResolver(AuthenticationDescriptor authDesc, TargetInfoHandler<T> infoHandler, Supplier<TargetPermissionVerifier<T>> verifierCreator, AuthenticationDescriptor.RbacAasComponent ... components) {
        RoleProvider roleProvider = new RoleProvider(){

            public List<String> getRoles() {
                ArrayList<String> result = new ArrayList<String>();
                Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                if (null == principal) {
                    Stream.of(AuthenticationDescriptor.Role.allAnonymous()).forEach(a -> result.add(a.name()));
                } else if (principal instanceof User) {
                    User user = (User)principal;
                    if (null != user.getAuthorities()) {
                        user.getAuthorities().forEach(a -> result.add(a.getAuthority()));
                    }
                } else if (principal instanceof String) {
                    result.add(principal.toString());
                }
                return result;
            }
        };
        InMemoryAuthorizationRbacStorage rbacStorage = new InMemoryAuthorizationRbacStorage(new HashMap());
        PreliminaryRbacRules tmpRules = new PreliminaryRbacRules();
        authDesc.getAccessRules().stream().filter(r -> RbacUtils.containsByRef(components, r.getComponent())).forEach(r -> {
            List<Action> actions = r.getActions().stream().map(a -> ACTION_MAPPING.get(a)).filter(a -> a != null).collect(Collectors.toList());
            tmpRules.addRule(r.getRole().name(), actions, infoHandler, (AuthenticationDescriptor.RbacRule)r);
        });
        tmpRules.addAll(rbacStorage);
        return new SimpleRbacPermissionResolver((RbacStorage)rbacStorage, roleProvider, (TargetPermissionVerifier)verifierCreator.get());
    }

    private static <T> boolean containsByRef(T[] array, T element) {
        for (T a : array) {
            if (a != element) continue;
            return true;
        }
        return false;
    }

    public static RbacPermissionResolver<SubmodelTargetInformation> createSubmodelPermissionResolver(AuthenticationDescriptor authDesc) {
        return RbacUtils.createPermissionResolver(authDesc, SubmodelInfoCreator.INSTANCE, () -> new SubmodelTargetPermissionVerifier(), AuthenticationDescriptor.RbacAasComponent.SUBMODEL, AuthenticationDescriptor.RbacAasComponent.SUBMODEL_ELEMENT);
    }

    public static RbacPermissionResolver<AasTargetInformation> createAasPermissionResolver(AuthenticationDescriptor authDesc) {
        return RbacUtils.createPermissionResolver(authDesc, AasInfoHandler.INSTANCE, () -> new AasTargetPermissionVerifier(), AuthenticationDescriptor.RbacAasComponent.AAS);
    }

    static {
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.CREATE, Action.CREATE);
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.DELETE, Action.DELETE);
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.EXECUTE, Action.EXECUTE);
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.READ, Action.READ);
        ACTION_MAPPING.put(AuthenticationDescriptor.RbacAction.UPDATE, Action.UPDATE);
    }

    private static class PreliminaryRbacRules<T extends TargetInformation> {
        private Map<String, PreliminaryRbacRule<T>> rules = new HashMap<String, PreliminaryRbacRule<T>>();

        private PreliminaryRbacRules() {
        }

        private void addRule(String role, List<Action> actions, TargetInfoHandler<T> infoHandler, AuthenticationDescriptor.RbacRule orig) {
            for (Action a : actions) {
                PreliminaryRbacRule<T> rule = new PreliminaryRbacRule<T>(role, a, infoHandler, orig);
                String key = rule.getKey();
                PreliminaryRbacRule<T> known = this.rules.get(key);
                if (null == known) {
                    this.rules.put(key, rule);
                    continue;
                }
                known.join(rule);
            }
        }

        private void addAll(InMemoryAuthorizationRbacStorage rbacStorage) {
            for (PreliminaryRbacRule<T> r : this.rules.values()) {
                rbacStorage.addRule(r.toRbacRule());
            }
        }
    }

    private static class PreliminaryRbacRule<T extends TargetInformation> {
        private String role;
        private Action action;
        private TargetInfoHandler<T> infoHandler;
        private T info;

        public PreliminaryRbacRule(String role, Action action, TargetInfoHandler<T> infoHandler, AuthenticationDescriptor.RbacRule orig) {
            this.role = role;
            this.action = action;
            this.infoHandler = infoHandler;
            this.info = infoHandler.create(orig);
        }

        public String getKey() {
            return RbacRuleKeyGenerator.generateKey((String)this.role, (String)this.action.toString(), (String)this.infoHandler.getTypeName());
        }

        public void join(PreliminaryRbacRule<T> rule) {
            this.info = this.infoHandler.join(this.info, rule.info);
        }

        public RbacRule toRbacRule() {
            return new RbacRule(this.role, List.of(this.action), this.info);
        }
    }
}

